/*
 * Decompiled with CFR 0.152.
 */
package net.esper.pattern.guard;

import net.esper.core.EPStatementHandleCallback;
import net.esper.core.ExtensionServicesContext;
import net.esper.pattern.MatchedEventMap;
import net.esper.pattern.PatternContext;
import net.esper.pattern.guard.Guard;
import net.esper.pattern.guard.Quitable;
import net.esper.schedule.ScheduleHandle;
import net.esper.schedule.ScheduleHandleCallback;
import net.esper.schedule.ScheduleSlot;

public class TimerWithinGuard
implements Guard,
ScheduleHandleCallback {
    private final long msec;
    private final PatternContext context;
    private final Quitable quitable;
    private final ScheduleSlot scheduleSlot;
    private boolean isTimerActive;
    private EPStatementHandleCallback scheduleHandle;

    public TimerWithinGuard(long msec, PatternContext context, Quitable quitable) {
        this.msec = msec;
        this.context = context;
        this.quitable = quitable;
        this.scheduleSlot = context.getScheduleBucket().allocateSlot();
    }

    public void startGuard() {
        if (this.isTimerActive) {
            throw new IllegalStateException("Timer already active");
        }
        this.scheduleHandle = new EPStatementHandleCallback(this.context.getEpStatementHandle(), this);
        this.context.getSchedulingService().add(this.msec, (ScheduleHandle)this.scheduleHandle, this.scheduleSlot);
        this.isTimerActive = true;
    }

    public void stopGuard() {
        if (this.isTimerActive) {
            this.context.getSchedulingService().remove(this.scheduleHandle, this.scheduleSlot);
            this.scheduleHandle = null;
            this.isTimerActive = false;
        }
    }

    public boolean inspect(MatchedEventMap matchEvent) {
        return true;
    }

    public final void scheduledTrigger(ExtensionServicesContext extensionServicesContext) {
        this.isTimerActive = false;
        this.quitable.guardQuit();
    }
}

