/*
 * Decompiled with CFR 0.152.
 */
package net.esper.pattern.guard;

import java.util.List;
import net.esper.pattern.PatternContext;
import net.esper.pattern.guard.Guard;
import net.esper.pattern.guard.GuardFactory;
import net.esper.pattern.guard.GuardParameterException;
import net.esper.pattern.guard.Quitable;
import net.esper.pattern.guard.TimerWithinGuard;
import net.esper.type.TimePeriodParameter;
import net.esper.util.JavaClassHelper;
import net.esper.util.MetaDefItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimerWithinGuardFactory
implements GuardFactory,
MetaDefItem {
    protected long milliseconds;

    @Override
    public void setGuardParameters(List<Object> guardParameters) throws GuardParameterException {
        String errorMessage = "Timer-within guard requires a single numeric or time period parameter";
        if (guardParameters.size() != 1) {
            throw new GuardParameterException(errorMessage);
        }
        Object parameter = guardParameters.get(0);
        if (parameter instanceof TimePeriodParameter) {
            TimePeriodParameter param = (TimePeriodParameter)parameter;
            this.milliseconds = Math.round(1000.0 * param.getNumSeconds());
        } else {
            if (!(parameter instanceof Number)) {
                throw new GuardParameterException(errorMessage);
            }
            Number param = (Number)parameter;
            this.milliseconds = JavaClassHelper.isFloatingPointNumber(param) ? Math.round(1000.0 * param.doubleValue()) : 1000L * param.longValue();
        }
    }

    @Override
    public Guard makeGuard(PatternContext context, Quitable quitable, Object stateNodeId, Object guardState) {
        return new TimerWithinGuard(this.milliseconds, context, quitable);
    }
}

