/*
 * Decompiled with CFR 0.152.
 */
package net.esper.pattern.observer;

import java.util.EnumMap;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import net.esper.pattern.MatchedEventMap;
import net.esper.pattern.PatternContext;
import net.esper.pattern.observer.EventObserver;
import net.esper.pattern.observer.ObserverEventEvaluator;
import net.esper.pattern.observer.ObserverFactory;
import net.esper.pattern.observer.ObserverParameterException;
import net.esper.pattern.observer.TimerAtObserver;
import net.esper.schedule.ScheduleSpec;
import net.esper.type.CronParameter;
import net.esper.type.NumberSetParameter;
import net.esper.type.ScheduleUnit;
import net.esper.util.MetaDefItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimerAtObserverFactory
implements ObserverFactory,
MetaDefItem {
    protected ScheduleSpec spec = null;
    private static final Log log = LogFactory.getLog(TimerAtObserverFactory.class);

    @Override
    public void setObserverParameters(List<Object> observerParameters) throws ObserverParameterException {
        if (log.isDebugEnabled()) {
            log.debug(".setObserverParameters " + observerParameters);
        }
        if (observerParameters.size() < 5 || observerParameters.size() > 6) {
            throw new ObserverParameterException("Invalid number of parameters for timer:at");
        }
        this.spec = TimerAtObserverFactory.computeValues(observerParameters.toArray());
    }

    private static SortedSet<Integer> computeValues(Object unitParameter, ScheduleUnit unit) throws ObserverParameterException {
        if (unitParameter instanceof Integer) {
            TreeSet<Integer> result = new TreeSet<Integer>();
            result.add((Integer)unitParameter);
            return result;
        }
        NumberSetParameter numberSet = (NumberSetParameter)unitParameter;
        if (numberSet.isWildcard(unit.min(), unit.min())) {
            return null;
        }
        Set<Integer> result = numberSet.getValuesInRange(unit.min(), unit.max());
        TreeSet<Integer> resultSorted = new TreeSet<Integer>();
        resultSorted.addAll(result);
        return resultSorted;
    }

    private static ScheduleSpec computeValues(Object[] args) throws ObserverParameterException {
        EnumMap<ScheduleUnit, SortedSet<Integer>> unitMap = new EnumMap<ScheduleUnit, SortedSet<Integer>>(ScheduleUnit.class);
        Object minutes = args[0];
        Object hours = args[1];
        Object daysOfMonth = args[2];
        Object months = args[3];
        Object daysOfWeek = args[4];
        unitMap.put(ScheduleUnit.MINUTES, TimerAtObserverFactory.computeValues(minutes, ScheduleUnit.MINUTES));
        unitMap.put(ScheduleUnit.HOURS, TimerAtObserverFactory.computeValues(hours, ScheduleUnit.HOURS));
        SortedSet<Integer> resultMonths = TimerAtObserverFactory.computeValues(months, ScheduleUnit.MONTHS);
        if (daysOfWeek instanceof CronParameter && daysOfMonth instanceof CronParameter) {
            throw new ObserverParameterException("Invalid combination between days of week and days of month fields for timer:at");
        }
        if (resultMonths != null && resultMonths.size() == 1 && resultMonths.first() instanceof Integer) {
            CronParameter parameter = null;
            if (daysOfMonth instanceof CronParameter) {
                parameter = (CronParameter)daysOfMonth;
            } else if (daysOfWeek instanceof CronParameter) {
                parameter = (CronParameter)daysOfWeek;
            }
            if (parameter != null) {
                parameter.setMonth(resultMonths.first());
            }
        }
        SortedSet<Integer> resultDaysOfWeek = TimerAtObserverFactory.computeValues(daysOfWeek, ScheduleUnit.DAYS_OF_WEEK);
        SortedSet<Integer> resultDaysOfMonth = TimerAtObserverFactory.computeValues(daysOfMonth, ScheduleUnit.DAYS_OF_MONTH);
        if (resultDaysOfWeek != null && resultDaysOfWeek.size() == 1 && resultDaysOfWeek.first() instanceof Integer && resultDaysOfWeek.first() > 6) {
            if (resultDaysOfMonth != null) {
                throw new ObserverParameterException("Invalid combination between days of week and days of month fields for timer:at");
            }
            resultDaysOfMonth = resultDaysOfWeek;
            resultDaysOfWeek = null;
        }
        if (resultDaysOfMonth != null && resultDaysOfMonth.size() == 1 && resultDaysOfMonth.first() instanceof Integer && resultDaysOfWeek != null) {
            throw new ObserverParameterException("Invalid combination between days of week and days of month fields for timer:at");
        }
        unitMap.put(ScheduleUnit.DAYS_OF_WEEK, resultDaysOfWeek);
        unitMap.put(ScheduleUnit.DAYS_OF_MONTH, resultDaysOfMonth);
        unitMap.put(ScheduleUnit.MONTHS, resultMonths);
        if (args.length > 5) {
            unitMap.put(ScheduleUnit.SECONDS, TimerAtObserverFactory.computeValues(args[5], ScheduleUnit.SECONDS));
        }
        return new ScheduleSpec(unitMap);
    }

    @Override
    public EventObserver makeObserver(PatternContext context, MatchedEventMap beginState, ObserverEventEvaluator observerEventEvaluator, Object stateNodeId, Object observerState) {
        return new TimerAtObserver(this.spec, context, beginState, observerEventEvaluator);
    }
}

