/*
 * Decompiled with CFR 0.152.
 */
package net.esper.pattern.observer;

import net.esper.core.EPStatementHandleCallback;
import net.esper.core.ExtensionServicesContext;
import net.esper.pattern.MatchedEventMap;
import net.esper.pattern.PatternContext;
import net.esper.pattern.observer.EventObserver;
import net.esper.pattern.observer.ObserverEventEvaluator;
import net.esper.schedule.ScheduleHandle;
import net.esper.schedule.ScheduleHandleCallback;
import net.esper.schedule.ScheduleSlot;

public class TimerIntervalObserver
implements EventObserver,
ScheduleHandleCallback {
    private final long msec;
    private final PatternContext context;
    private final MatchedEventMap beginState;
    private final ObserverEventEvaluator observerEventEvaluator;
    private final ScheduleSlot scheduleSlot;
    private boolean isTimerActive = false;
    private EPStatementHandleCallback scheduleHandle;

    public TimerIntervalObserver(long msec, PatternContext context, MatchedEventMap beginState, ObserverEventEvaluator observerEventEvaluator) {
        this.msec = msec;
        this.context = context;
        this.beginState = beginState;
        this.observerEventEvaluator = observerEventEvaluator;
        this.scheduleSlot = context.getScheduleBucket().allocateSlot();
    }

    public final void scheduledTrigger(ExtensionServicesContext extensionServicesContext) {
        this.observerEventEvaluator.observerEvaluateTrue(this.beginState);
        this.isTimerActive = false;
    }

    public void startObserve() {
        if (this.isTimerActive) {
            throw new IllegalStateException("Timer already active");
        }
        if (this.msec <= 0L) {
            this.observerEventEvaluator.observerEvaluateTrue(this.beginState);
        } else {
            this.scheduleHandle = new EPStatementHandleCallback(this.context.getEpStatementHandle(), this);
            this.context.getSchedulingService().add(this.msec, (ScheduleHandle)this.scheduleHandle, this.scheduleSlot);
            this.isTimerActive = true;
        }
    }

    public void stopObserve() {
        if (this.isTimerActive) {
            this.context.getSchedulingService().remove(this.scheduleHandle, this.scheduleSlot);
            this.isTimerActive = false;
            this.scheduleHandle = null;
        }
    }
}

