/*
 * Decompiled with CFR 0.152.
 */
package net.esper.pattern.observer;

import java.util.List;
import net.esper.pattern.MatchedEventMap;
import net.esper.pattern.PatternContext;
import net.esper.pattern.observer.EventObserver;
import net.esper.pattern.observer.ObserverEventEvaluator;
import net.esper.pattern.observer.ObserverFactory;
import net.esper.pattern.observer.ObserverParameterException;
import net.esper.pattern.observer.TimerIntervalObserver;
import net.esper.type.TimePeriodParameter;
import net.esper.util.JavaClassHelper;
import net.esper.util.MetaDefItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimerIntervalObserverFactory
implements ObserverFactory,
MetaDefItem {
    protected long milliseconds;

    @Override
    public void setObserverParameters(List<Object> observerParameters) throws ObserverParameterException {
        String errorMessage = "Timer-interval observer requires a single numeric or time period parameter";
        if (observerParameters.size() != 1) {
            throw new ObserverParameterException(errorMessage);
        }
        Object parameter = observerParameters.get(0);
        if (parameter instanceof TimePeriodParameter) {
            TimePeriodParameter param = (TimePeriodParameter)parameter;
            this.milliseconds = Math.round(1000.0 * param.getNumSeconds());
        } else {
            if (!(parameter instanceof Number)) {
                throw new ObserverParameterException(errorMessage);
            }
            Number param = (Number)parameter;
            this.milliseconds = JavaClassHelper.isFloatingPointNumber(param) ? Math.round(1000.0 * param.doubleValue()) : 1000L * param.longValue();
        }
    }

    @Override
    public EventObserver makeObserver(PatternContext context, MatchedEventMap beginState, ObserverEventEvaluator observerEventEvaluator, Object stateNodeId, Object observerState) {
        return new TimerIntervalObserver(this.milliseconds, context, beginState, observerEventEvaluator);
    }
}

