/*
 * Decompiled with CFR 0.152.
 */
package net.esper.schedule;

import java.util.Collection;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import net.esper.schedule.ScheduleBucket;
import net.esper.schedule.ScheduleComputeHelper;
import net.esper.schedule.ScheduleHandle;
import net.esper.schedule.ScheduleHandleExistsException;
import net.esper.schedule.ScheduleServiceException;
import net.esper.schedule.ScheduleSlot;
import net.esper.schedule.ScheduleSpec;
import net.esper.schedule.SchedulingService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SchedulingServiceImpl
implements SchedulingService {
    private final SortedMap<Long, SortedMap<ScheduleSlot, ScheduleHandle>> timeHandleMap = new TreeMap<Long, SortedMap<ScheduleSlot, ScheduleHandle>>();
    private final Map<ScheduleHandle, SortedMap<ScheduleSlot, ScheduleHandle>> handleSetMap = new Hashtable<ScheduleHandle, SortedMap<ScheduleSlot, ScheduleHandle>>();
    private volatile long currentTime = System.currentTimeMillis();
    private int curBucketNum;
    private static final Log log = LogFactory.getLog(SchedulingServiceImpl.class);

    @Override
    public void destroy() {
        this.handleSetMap.clear();
        this.timeHandleMap.clear();
    }

    @Override
    public synchronized ScheduleBucket allocateBucket() {
        ++this.curBucketNum;
        return new ScheduleBucket(this.curBucketNum);
    }

    @Override
    public long getTime() {
        return this.currentTime;
    }

    @Override
    public final synchronized void setTime(long currentTime) {
        this.currentTime = currentTime;
    }

    @Override
    public final synchronized void add(long afterMSec, ScheduleHandle handle, ScheduleSlot slot) throws ScheduleServiceException {
        if (this.handleSetMap.containsKey(handle)) {
            String message = "Handle already in collection";
            log.fatal(".add " + message);
            throw new ScheduleHandleExistsException(message);
        }
        long triggerOnTime = this.currentTime + afterMSec;
        this.addTrigger(slot, handle, triggerOnTime);
    }

    @Override
    public final synchronized void add(ScheduleSpec spec, ScheduleHandle handle, ScheduleSlot slot) {
        if (this.handleSetMap.containsKey(handle)) {
            String message = "Handle already in collection";
            log.fatal(".add " + message);
            throw new ScheduleHandleExistsException(message);
        }
        long nextScheduledTime = ScheduleComputeHelper.computeNextOccurance(spec, this.currentTime);
        if (nextScheduledTime <= this.currentTime) {
            String message = "Schedule computation returned invalid time, operation not completed";
            log.fatal(".add " + message + "  nextScheduledTime=" + nextScheduledTime + "  currentTime=" + this.currentTime);
            assert (false);
            return;
        }
        this.addTrigger(slot, handle, nextScheduledTime);
    }

    @Override
    public final synchronized void remove(ScheduleHandle handle, ScheduleSlot slot) {
        SortedMap<ScheduleSlot, ScheduleHandle> handleSet = this.handleSetMap.get(handle);
        if (handleSet == null) {
            return;
        }
        handleSet.remove(slot);
        this.handleSetMap.remove(handle);
    }

    @Override
    public final synchronized void evaluate(Collection<ScheduleHandle> handles) {
        SortedMap<Long, SortedMap<ScheduleSlot, ScheduleHandle>> headMap = this.timeHandleMap.headMap(this.currentTime + 1L);
        LinkedList<Long> removeKeys = new LinkedList<Long>();
        for (Map.Entry<Long, SortedMap<ScheduleSlot, ScheduleHandle>> entry : headMap.entrySet()) {
            Long key = entry.getKey();
            SortedMap<ScheduleSlot, ScheduleHandle> value = entry.getValue();
            removeKeys.add(key);
            for (ScheduleHandle handle : value.values()) {
                handles.add(handle);
            }
        }
        for (Map.Entry<Long, SortedMap<ScheduleSlot, ScheduleHandle>> entry : headMap.entrySet()) {
            for (ScheduleHandle handle : entry.getValue().values()) {
                this.handleSetMap.remove(handle);
            }
        }
        for (Long key : removeKeys) {
            this.timeHandleMap.remove(key);
        }
    }

    private void addTrigger(ScheduleSlot slot, ScheduleHandle handle, long triggerTime) {
        TreeMap<ScheduleSlot, ScheduleHandle> handleSet = (TreeMap<ScheduleSlot, ScheduleHandle>)this.timeHandleMap.get(triggerTime);
        if (handleSet == null) {
            handleSet = new TreeMap<ScheduleSlot, ScheduleHandle>();
            this.timeHandleMap.put(triggerTime, handleSet);
        }
        handleSet.put(slot, handle);
        this.handleSetMap.put(handle, handleSet);
    }
}

