/*
 * Decompiled with CFR 0.152.
 */
package net.esper.timer;

import java.util.Timer;
import java.util.TimerTask;
import net.esper.timer.EQLTimerTask;
import net.esper.timer.TimerCallback;
import net.esper.timer.TimerService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class TimerServiceImpl
implements TimerService {
    private final long msecTimerResolution;
    private TimerCallback timerCallback;
    private Timer timer;
    private EQLTimerTask timerTask;
    private static final Log log = LogFactory.getLog(TimerServiceImpl.class);

    public TimerServiceImpl(long msecTimerResolution) {
        this.msecTimerResolution = msecTimerResolution;
    }

    public long getMsecTimerResolution() {
        return this.msecTimerResolution;
    }

    public void setCallback(TimerCallback timerCallback) {
        this.timerCallback = timerCallback;
    }

    public final void startInternalClock() {
        if (this.timer != null) {
            log.warn(".startInternalClock Internal clock is already started, stop first before starting, operation not completed");
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(".startInternalClock Starting internal clock daemon thread, resolution=" + this.msecTimerResolution);
        }
        if (this.timerCallback == null) {
            throw new IllegalStateException("Timer callback not set");
        }
        this.timer = new Timer(true);
        this.timerTask = new EQLTimerTask(this.timerCallback);
        this.timer.scheduleAtFixedRate((TimerTask)this.timerTask, 0L, this.msecTimerResolution);
    }

    public final void stopInternalClock(boolean warnIfNotStarted) {
        if (this.timer == null) {
            if (warnIfNotStarted) {
                log.warn(".stopInternalClock Internal clock is already stopped, start first before stopping, operation not completed");
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(".stopInternalClock Stopping internal clock daemon thread");
        }
        this.timerTask.setCancelled(true);
        this.timerTask.cancel();
        this.timer.cancel();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            log.info("Timer start wait interval interruped");
        }
        this.timer = null;
    }
}

