/*
 * Decompiled with CFR 0.152.
 */
package net.esper.type;

import net.esper.type.PrimitiveValueBase;
import net.esper.type.PrimitiveValueType;

public final class BoolValue
extends PrimitiveValueBase {
    private Boolean boolValue;

    public PrimitiveValueType getType() {
        return PrimitiveValueType.BOOL;
    }

    public BoolValue(Boolean boolValue) {
        this.boolValue = boolValue;
    }

    public BoolValue() {
    }

    public static boolean parseString(String value) {
        if (!value.toLowerCase().equals("true") && !value.toLowerCase().equals("false")) {
            throw new IllegalArgumentException("Boolean value '" + value + "' cannot be converted to boolean");
        }
        return Boolean.parseBoolean(value);
    }

    public static boolean[] parseString(String[] values) {
        boolean[] result = new boolean[values.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = BoolValue.parseString(values[i]);
        }
        return result;
    }

    public final void parse(String value) {
        this.boolValue = BoolValue.parseString(value);
    }

    public final Object getValueObject() {
        return this.boolValue;
    }

    public final void setBoolean(boolean x) {
        this.boolValue = x;
    }

    public final String toString() {
        if (this.boolValue == null) {
            return "null";
        }
        return this.boolValue.toString();
    }
}

