/*
 * Decompiled with CFR 0.152.
 */
package net.esper.type;

import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import net.esper.type.IntValue;
import net.esper.type.NumberSetParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CronParameter
implements NumberSetParameter {
    private CronOperator operator;
    private Calendar calendar;
    private Integer day;
    private Integer month;
    private static int FIRST_DAY_OF_WEEK = 1;

    @Override
    public void toEQL(StringWriter writer) {
        writer.write(this.operator.toString());
    }

    public CronParameter(String cronOperator, String day) {
        this.operator = CronParameter.assignOperator(cronOperator);
        if (day != null) {
            this.day = IntValue.parseString(day);
        }
        this.calendar = Calendar.getInstance();
        this.calendar.setFirstDayOfWeek(FIRST_DAY_OF_WEEK);
    }

    public void setMonth(int month) {
        this.month = month - 1;
    }

    @Override
    public boolean isWildcard(int min, int max) {
        return false;
    }

    @Override
    public Set<Integer> getValuesInRange(int min, int max) {
        HashSet<Integer> values = new HashSet<Integer>();
        if (min != 0 && min != 1 || max != 6 && max != 31) {
            throw new IllegalArgumentException("Invalid usage for timer:at");
        }
        switch (this.operator) {
            case last: {
                if (min == 0 && max == 6) {
                    if (this.day == null) {
                        values.add(this.determineLastDayOfWeek());
                        break;
                    }
                    values.add(this.determineLastDayOfWeekInMonth());
                    break;
                }
                if (min == 1 && max == 31) {
                    if (this.day == null) {
                        values.add(this.determineLastDayOfMonth());
                        break;
                    }
                    values.add(this.determineLastDayOfWeekInMonth());
                    break;
                }
                throw new IllegalArgumentException("Invalid value for last operator");
            }
            case lw: {
                values.add(this.determineLastWeekDayOfMonth());
                break;
            }
            case w: {
                values.add(this.determineLastWeekDayOfMonth());
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid special operator for observer");
            }
        }
        return values;
    }

    private int determineLastDayOfMonth() {
        this.setTime();
        this.calendar.set(5, this.calendar.getActualMaximum(5));
        return this.calendar.get(5);
    }

    private int determineLastDayOfWeekInMonth() {
        if (this.day == null) {
            return this.determineLastDayOfMonth();
        }
        if (this.day < 0 || this.day > 7) {
            throw new IllegalArgumentException("Last xx day of the month has to be a day of week (0-7)");
        }
        int dayOfWeek = this.getDayOfWeek();
        this.setTime();
        this.calendar.set(5, this.calendar.getActualMaximum(5));
        int dayDiff = this.calendar.get(7) - dayOfWeek;
        if (dayDiff > 0) {
            this.calendar.add(7, -dayDiff);
        } else if (dayDiff < 0) {
            this.calendar.add(7, -7 - dayDiff);
        }
        return this.calendar.get(5);
    }

    private int determineLastDayOfWeek() {
        this.setTime();
        this.calendar.set(7, 7);
        return this.calendar.get(7) - 1;
    }

    private int getDayOfWeek() {
        this.setTime();
        if (this.day == null) {
            this.calendar.set(7, 7);
        } else {
            this.calendar.set(7, this.day + 1);
        }
        return this.calendar.get(7);
    }

    private int determineLastWeekDayOfMonth() {
        int computeDay = this.day == null ? this.determineLastDayOfMonth() : this.day.intValue();
        this.setTime();
        if (!CronParameter.checkDayValidInMonth(computeDay, this.calendar.get(2), this.calendar.get(1))) {
            throw new IllegalArgumentException("Invalid day for " + this.calendar.get(2));
        }
        this.calendar.set(5, computeDay);
        int dayOfWeek = this.calendar.get(7);
        if (dayOfWeek >= 2 && dayOfWeek <= 6) {
            return computeDay;
        }
        if (dayOfWeek == 7) {
            if (computeDay == 1) {
                this.calendar.add(5, 2);
            } else {
                this.calendar.add(5, -1);
            }
        }
        if (dayOfWeek == 1) {
            if (computeDay == 28 || computeDay == 29 || computeDay == 30 || computeDay == 31) {
                this.calendar.add(5, -2);
            } else {
                this.calendar.add(5, 2);
            }
        }
        return this.calendar.get(5);
    }

    private static boolean checkDayValidInMonth(int day, int month, int year) {
        try {
            Calendar calendar = Calendar.getInstance();
            calendar.setLenient(false);
            calendar.set(1, year);
            calendar.set(2, month);
            calendar.set(5, day);
            calendar.getTime();
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    private static CronOperator assignOperator(String name) {
        if (name.equalsIgnoreCase("last") || name.equalsIgnoreCase("lastoperator")) {
            return CronOperator.last;
        }
        if (name.equalsIgnoreCase("weekdayoperator")) {
            return CronOperator.w;
        }
        if (name.equalsIgnoreCase("lastweekday")) {
            return CronOperator.lw;
        }
        return null;
    }

    private void printTime() {
        Date date = this.calendar.getTime();
        String aMonth = new SimpleDateFormat("MMM").format(date);
        String aDay = new SimpleDateFormat("EEE").format(date);
        System.out.println("This day: " + aDay + " of " + aMonth + " " + this.calendar.get(1));
    }

    private void setTime() {
        Date date = new Date();
        this.calendar.setTime(date);
        this.calendar.set(5, 1);
        if (this.month != null) {
            this.calendar.set(2, this.month);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CronOperator {
        last,
        w,
        lw;

    }
}

