/*
 * Decompiled with CFR 0.152.
 */
package net.esper.type;

import java.io.StringWriter;
import java.util.HashSet;
import java.util.Set;
import net.esper.type.NumberSetParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrequencyParameter
implements NumberSetParameter {
    private int frequency;

    public FrequencyParameter(int frequency) {
        this.frequency = frequency;
        if (frequency <= 0) {
            throw new IllegalArgumentException("Zero or negative value supplied as freqeuncy");
        }
    }

    public int getFrequency() {
        return this.frequency;
    }

    @Override
    public boolean isWildcard(int min, int max) {
        return this.frequency == 1;
    }

    @Override
    public Set<Integer> getValuesInRange(int min, int max) {
        HashSet<Integer> values = new HashSet<Integer>();
        int start = min - min % this.frequency;
        do {
            if (start < min) continue;
            values.add(start);
        } while ((start += this.frequency) <= max);
        return values;
    }

    @Override
    public void toEQL(StringWriter writer) {
        writer.write("*/");
        writer.write(Integer.toString(this.frequency));
    }
}

