/*
 * Decompiled with CFR 0.152.
 */
package net.esper.type;

import java.util.HashMap;
import java.util.Map;
import net.esper.collection.MultiKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum MathArithTypeEnum {
    ADD("+"),
    SUBTRACT("-"),
    DIVIDE("/"),
    MULTIPLY("*"),
    MODULO("%");

    private static Map<MultiKey<Object>, Computer> computers;
    private String expressionText;

    private MathArithTypeEnum(String expressionText) {
        this.expressionText = expressionText;
    }

    public Computer getComputer(Class coercedType) {
        if (coercedType != Double.class && coercedType != Float.class && coercedType != Long.class && coercedType != Integer.class) {
            throw new IllegalArgumentException("Expected base numeric type for computation result but got type " + coercedType);
        }
        MultiKey<Object> key = new MultiKey<Object>(new Object[]{coercedType, this});
        Computer computer = computers.get(key);
        if (computer == null) {
            throw new IllegalArgumentException("Could not determine process or type " + (Object)((Object)this) + " type " + coercedType);
        }
        return computer;
    }

    public String getExpressionText() {
        return this.expressionText;
    }

    public static MathArithTypeEnum parseOperator(String operator) {
        for (int i = 0; i < MathArithTypeEnum.values().length; ++i) {
            MathArithTypeEnum val = MathArithTypeEnum.values()[i];
            if (!val.getExpressionText().equals(operator)) continue;
            return MathArithTypeEnum.values()[i];
        }
        throw new IllegalArgumentException("Unknown operator '" + operator + "'");
    }

    static {
        computers = new HashMap<MultiKey<Object>, Computer>();
        computers.put(new MultiKey<Object>(new Object[]{Double.class, ADD}), new AddDouble());
        computers.put(new MultiKey<Object>(new Object[]{Float.class, ADD}), new AddFloat());
        computers.put(new MultiKey<Object>(new Object[]{Long.class, ADD}), new AddLong());
        computers.put(new MultiKey<Object>(new Object[]{Integer.class, ADD}), new AddInt());
        computers.put(new MultiKey<Object>(new Object[]{Double.class, SUBTRACT}), new SubtractDouble());
        computers.put(new MultiKey<Object>(new Object[]{Float.class, SUBTRACT}), new SubtractFloat());
        computers.put(new MultiKey<Object>(new Object[]{Long.class, SUBTRACT}), new SubtractLong());
        computers.put(new MultiKey<Object>(new Object[]{Integer.class, SUBTRACT}), new SubtractInt());
        computers.put(new MultiKey<Object>(new Object[]{Double.class, DIVIDE}), new DivideDouble());
        computers.put(new MultiKey<Object>(new Object[]{Float.class, DIVIDE}), new DivideFloat());
        computers.put(new MultiKey<Object>(new Object[]{Long.class, DIVIDE}), new DivideLong());
        computers.put(new MultiKey<Object>(new Object[]{Integer.class, DIVIDE}), new DivideInt());
        computers.put(new MultiKey<Object>(new Object[]{Double.class, MULTIPLY}), new MultiplyDouble());
        computers.put(new MultiKey<Object>(new Object[]{Float.class, MULTIPLY}), new MultiplyFloat());
        computers.put(new MultiKey<Object>(new Object[]{Long.class, MULTIPLY}), new MultiplyLong());
        computers.put(new MultiKey<Object>(new Object[]{Integer.class, MULTIPLY}), new MultiplyInt());
        computers.put(new MultiKey<Object>(new Object[]{Double.class, MODULO}), new ModuloDouble());
        computers.put(new MultiKey<Object>(new Object[]{Float.class, MODULO}), new ModuloFloat());
        computers.put(new MultiKey<Object>(new Object[]{Long.class, MODULO}), new ModuloLong());
        computers.put(new MultiKey<Object>(new Object[]{Integer.class, MODULO}), new ModuloInt());
    }

    public static class ModuloInt
    implements Computer {
        public Number compute(Number d1, Number d2) {
            return d1.intValue() % d2.intValue();
        }
    }

    public static class ModuloLong
    implements Computer {
        public Number compute(Number d1, Number d2) {
            return d1.longValue() % d2.longValue();
        }
    }

    public static class ModuloFloat
    implements Computer {
        public Number compute(Number d1, Number d2) {
            return Float.valueOf(d1.floatValue() % d2.floatValue());
        }
    }

    public static class ModuloDouble
    implements Computer {
        public Number compute(Number d1, Number d2) {
            return d1.doubleValue() % d2.doubleValue();
        }
    }

    public static class MultiplyInt
    implements Computer {
        public Number compute(Number d1, Number d2) {
            return d1.intValue() * d2.intValue();
        }
    }

    public static class MultiplyLong
    implements Computer {
        public Number compute(Number d1, Number d2) {
            return d1.longValue() * d2.longValue();
        }
    }

    public static class MultiplyFloat
    implements Computer {
        public Number compute(Number d1, Number d2) {
            return Float.valueOf(d1.floatValue() * d2.floatValue());
        }
    }

    public static class MultiplyDouble
    implements Computer {
        public Number compute(Number d1, Number d2) {
            return d1.doubleValue() * d2.doubleValue();
        }
    }

    public static class DivideInt
    implements Computer {
        public Number compute(Number d1, Number d2) {
            return d1.intValue() / d2.intValue();
        }
    }

    public static class DivideLong
    implements Computer {
        public Number compute(Number d1, Number d2) {
            return d1.longValue() / d2.longValue();
        }
    }

    public static class DivideFloat
    implements Computer {
        public Number compute(Number d1, Number d2) {
            return Float.valueOf(d1.floatValue() / d2.floatValue());
        }
    }

    public static class DivideDouble
    implements Computer {
        public Number compute(Number d1, Number d2) {
            return d1.doubleValue() / d2.doubleValue();
        }
    }

    public static class SubtractInt
    implements Computer {
        public Number compute(Number d1, Number d2) {
            return d1.intValue() - d2.intValue();
        }
    }

    public static class SubtractLong
    implements Computer {
        public Number compute(Number d1, Number d2) {
            return d1.longValue() - d2.longValue();
        }
    }

    public static class SubtractFloat
    implements Computer {
        public Number compute(Number d1, Number d2) {
            return Float.valueOf(d1.floatValue() - d2.floatValue());
        }
    }

    public static class SubtractDouble
    implements Computer {
        public Number compute(Number d1, Number d2) {
            return d1.doubleValue() - d2.doubleValue();
        }
    }

    public static class AddInt
    implements Computer {
        public Number compute(Number d1, Number d2) {
            return d1.intValue() + d2.intValue();
        }
    }

    public static class AddLong
    implements Computer {
        public Number compute(Number d1, Number d2) {
            return d1.longValue() + d2.longValue();
        }
    }

    public static class AddFloat
    implements Computer {
        public Number compute(Number d1, Number d2) {
            return Float.valueOf(d1.floatValue() + d2.floatValue());
        }
    }

    public static class AddDouble
    implements Computer {
        public Number compute(Number d1, Number d2) {
            return d1.doubleValue() + d2.doubleValue();
        }
    }

    public static interface Computer {
        public Number compute(Number var1, Number var2);
    }
}

