/*
 * Decompiled with CFR 0.152.
 */
package net.esper.type;

import java.util.HashMap;
import java.util.Map;
import net.esper.collection.MultiKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum RelationalOpEnum {
    GT(">"),
    GE(">="),
    LT("<"),
    LE("<=");

    private static Map<MultiKey<Object>, Computer> computers;
    private String expressionText;

    private RelationalOpEnum(String expressionText) {
        this.expressionText = expressionText;
    }

    public static RelationalOpEnum parse(String op) {
        if (op.equals("<")) {
            return LT;
        }
        if (op.equals(">")) {
            return GT;
        }
        if (op.equals(">=") || op.equals("=>")) {
            return GE;
        }
        if (op.equals("<=") || op.equals("=<")) {
            return LE;
        }
        throw new IllegalArgumentException("Invalid relational operator '" + op + "'");
    }

    public Computer getComputer(Class coercedType) {
        if (coercedType != Double.class && coercedType != Long.class && coercedType != String.class) {
            throw new IllegalArgumentException("Unsupported type for relational op compare, type " + coercedType);
        }
        MultiKey<Object> key = new MultiKey<Object>(new Object[]{coercedType, this});
        return computers.get(key);
    }

    public String getExpressionText() {
        return this.expressionText;
    }

    static {
        computers = new HashMap<MultiKey<Object>, Computer>();
        computers.put(new MultiKey<Object>(new Object[]{String.class, GT}), new GTStringComputer());
        computers.put(new MultiKey<Object>(new Object[]{String.class, GE}), new GEStringComputer());
        computers.put(new MultiKey<Object>(new Object[]{String.class, LT}), new LTStringComputer());
        computers.put(new MultiKey<Object>(new Object[]{String.class, LE}), new LEStringComputer());
        computers.put(new MultiKey<Object>(new Object[]{Long.class, GT}), new GTLongComputer());
        computers.put(new MultiKey<Object>(new Object[]{Long.class, GE}), new GELongComputer());
        computers.put(new MultiKey<Object>(new Object[]{Long.class, LT}), new LTLongComputer());
        computers.put(new MultiKey<Object>(new Object[]{Long.class, LE}), new LELongComputer());
        computers.put(new MultiKey<Object>(new Object[]{Double.class, GT}), new GTDoubleComputer());
        computers.put(new MultiKey<Object>(new Object[]{Double.class, GE}), new GEDoubleComputer());
        computers.put(new MultiKey<Object>(new Object[]{Double.class, LT}), new LTDoubleComputer());
        computers.put(new MultiKey<Object>(new Object[]{Double.class, LE}), new LEDoubleComputer());
    }

    public static class LEDoubleComputer
    implements Computer {
        public boolean compare(Object objOne, Object objTwo) {
            Number s1 = (Number)objOne;
            Number s2 = (Number)objTwo;
            return s1.doubleValue() <= s2.doubleValue();
        }
    }

    public static class LTDoubleComputer
    implements Computer {
        public boolean compare(Object objOne, Object objTwo) {
            Number s1 = (Number)objOne;
            Number s2 = (Number)objTwo;
            return s1.doubleValue() < s2.doubleValue();
        }
    }

    public static class GEDoubleComputer
    implements Computer {
        public boolean compare(Object objOne, Object objTwo) {
            Number s1 = (Number)objOne;
            Number s2 = (Number)objTwo;
            return s1.doubleValue() >= s2.doubleValue();
        }
    }

    public static class GTDoubleComputer
    implements Computer {
        public boolean compare(Object objOne, Object objTwo) {
            Number s1 = (Number)objOne;
            Number s2 = (Number)objTwo;
            return s1.doubleValue() > s2.doubleValue();
        }
    }

    public static class LELongComputer
    implements Computer {
        public boolean compare(Object objOne, Object objTwo) {
            Number s1 = (Number)objOne;
            Number s2 = (Number)objTwo;
            return s1.longValue() <= s2.longValue();
        }
    }

    public static class LTLongComputer
    implements Computer {
        public boolean compare(Object objOne, Object objTwo) {
            Number s1 = (Number)objOne;
            Number s2 = (Number)objTwo;
            return s1.longValue() < s2.longValue();
        }
    }

    public static class GELongComputer
    implements Computer {
        public boolean compare(Object objOne, Object objTwo) {
            Number s1 = (Number)objOne;
            Number s2 = (Number)objTwo;
            return s1.longValue() >= s2.longValue();
        }
    }

    public static class GTLongComputer
    implements Computer {
        public boolean compare(Object objOne, Object objTwo) {
            Number s1 = (Number)objOne;
            Number s2 = (Number)objTwo;
            return s1.longValue() > s2.longValue();
        }
    }

    public static class LTStringComputer
    implements Computer {
        public boolean compare(Object objOne, Object objTwo) {
            String s1 = (String)objOne;
            String s2 = (String)objTwo;
            return s1.compareTo(s2) < 0;
        }
    }

    public static class LEStringComputer
    implements Computer {
        public boolean compare(Object objOne, Object objTwo) {
            String s1 = (String)objOne;
            String s2 = (String)objTwo;
            return s1.compareTo(s2) <= 0;
        }
    }

    public static class GEStringComputer
    implements Computer {
        public boolean compare(Object objOne, Object objTwo) {
            String s1 = (String)objOne;
            String s2 = (String)objTwo;
            return s1.compareTo(s2) >= 0;
        }
    }

    public static class GTStringComputer
    implements Computer {
        public boolean compare(Object objOne, Object objTwo) {
            String s1 = (String)objOne;
            String s2 = (String)objTwo;
            int result = s1.compareTo(s2);
            return result > 0;
        }
    }

    public static interface Computer {
        public boolean compare(Object var1, Object var2);
    }
}

