/*
 * Decompiled with CFR 0.152.
 */
package net.esper.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import net.esper.util.ExecutionPathDebugLog;
import net.esper.util.JavaClassHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConstructorHelper {
    private static Class[] EMPTY_OBJECT_ARRAY_TYPE = new Class[]{new Object[0].getClass()};
    private static final Log log = LogFactory.getLog(ConstructorHelper.class);

    public static Object invokeConstructor(Class clazz, Object[] arguments) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException, InstantiationException {
        if (log.isDebugEnabled()) {
            ConstructorHelper.logConstructors(clazz);
        }
        Class[] parameterTypes = new Class[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            parameterTypes[i] = arguments[i].getClass();
        }
        Constructor ctor = ConstructorHelper.getRegularConstructor(clazz, parameterTypes);
        if (ctor != null) {
            return ctor.newInstance(arguments);
        }
        ctor = ConstructorHelper.findMatchingConstructor(clazz, parameterTypes);
        if (ctor != null) {
            return ctor.newInstance(arguments);
        }
        ctor = ConstructorHelper.getObjectArrayConstructor(clazz);
        return ctor.newInstance(new Object[]{arguments});
    }

    private static Constructor findMatchingConstructor(Class clazz, Class[] parameterTypes) {
        Constructor<?>[] ctors = clazz.getConstructors();
        for (int i = 0; i < ctors.length; ++i) {
            Class[] ctorParams = ctors[i].getParameterTypes();
            if (!ConstructorHelper.isAssignmentCompatible(parameterTypes, ctorParams)) continue;
            return ctors[i];
        }
        return null;
    }

    private static boolean isAssignmentCompatible(Class[] parameterTypes, Class[] ctorParams) {
        if (parameterTypes.length != ctorParams.length) {
            return false;
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (JavaClassHelper.isAssignmentCompatible(ctorParams[i], parameterTypes[i])) continue;
            return false;
        }
        return true;
    }

    private static Constructor getRegularConstructor(Class clazz, Class[] parameterTypes) {
        try {
            Constructor ctor = clazz.getConstructor(parameterTypes);
            try {
                ctor.setAccessible(true);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            return ctor;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    private static Constructor getObjectArrayConstructor(Class clazz) throws NoSuchMethodException {
        return clazz.getConstructor(EMPTY_OBJECT_ARRAY_TYPE);
    }

    private static void logConstructors(Class clazz) {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".invokeConstructor Constructors for class " + clazz);
        }
        Constructor<?>[] ctors = clazz.getConstructors();
        int size = ctors.length;
        for (int i = 0; i < size; ++i) {
            Object[] ctorParams = ctors[i].getParameterTypes();
            if (!ExecutionPathDebugLog.isDebugEnabled || !log.isDebugEnabled()) continue;
            log.debug(".invokeConstructor Constructor " + i + ' ' + Arrays.toString(ctorParams));
        }
    }
}

