/*
 * Decompiled with CFR 0.152.
 */
package net.esper.util;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import net.esper.util.DatabaseTypeBinding;
import net.esper.util.JavaClassHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum DatabaseTypeEnum {
    String(String.class),
    BigDecimal(BigDecimal.class),
    Boolean(Boolean.class),
    Byte(Byte.class),
    Short(Short.class),
    Int(Integer.class),
    Long(Long.class),
    Float(Float.class),
    Double(Double.class),
    ByteArray(byte[].class),
    SqlDate(Date.class),
    SqlTime(Time.class),
    SqlTimestamp(Timestamp.class);

    private Class javaClass;
    private static Map<DatabaseTypeEnum, DatabaseTypeBinding> bindings;

    private DatabaseTypeEnum(Class javaClass) {
        this.javaClass = javaClass;
    }

    public Class getJavaClass() {
        return this.javaClass;
    }

    public static DatabaseTypeEnum getEnum(String type) {
        String boxedType = JavaClassHelper.getBoxedClassName(type);
        for (DatabaseTypeEnum val : DatabaseTypeEnum.values()) {
            if (val.toString().toLowerCase().equals(type.toLowerCase())) {
                return val;
            }
            if (val.getJavaClass().getName().toLowerCase().equals(type.toLowerCase())) {
                return val;
            }
            if (val.getJavaClass().getName().toLowerCase().equals(boxedType)) {
                return val;
            }
            if (!val.getJavaClass().getSimpleName().toLowerCase().equals(boxedType)) continue;
            return val;
        }
        return null;
    }

    public DatabaseTypeBinding getBinding() {
        return bindings.get((Object)this);
    }

    static {
        bindings = new HashMap<DatabaseTypeEnum, DatabaseTypeBinding>();
        bindings.put(String, new DatabaseTypeBinding(){

            public Object getValue(ResultSet resultSet, String columnName) throws SQLException {
                return resultSet.getString(columnName);
            }

            public Class getType() {
                return String.class;
            }
        });
        bindings.put(BigDecimal, new DatabaseTypeBinding(){

            public Object getValue(ResultSet resultSet, String columnName) throws SQLException {
                return resultSet.getBigDecimal(columnName);
            }

            public Class getType() {
                return BigDecimal.class;
            }
        });
        bindings.put(Boolean, new DatabaseTypeBinding(){

            public Object getValue(ResultSet resultSet, String columnName) throws SQLException {
                return resultSet.getBoolean(columnName);
            }

            public Class getType() {
                return Boolean.class;
            }
        });
        bindings.put(Byte, new DatabaseTypeBinding(){

            public Object getValue(ResultSet resultSet, String columnName) throws SQLException {
                return resultSet.getByte(columnName);
            }

            public Class getType() {
                return Byte.class;
            }
        });
        bindings.put(ByteArray, new DatabaseTypeBinding(){

            public Object getValue(ResultSet resultSet, String columnName) throws SQLException {
                return resultSet.getBytes(columnName);
            }

            public Class getType() {
                return byte[].class;
            }
        });
        bindings.put(Double, new DatabaseTypeBinding(){

            public Object getValue(ResultSet resultSet, String columnName) throws SQLException {
                return resultSet.getDouble(columnName);
            }

            public Class getType() {
                return Double.class;
            }
        });
        bindings.put(Float, new DatabaseTypeBinding(){

            public Object getValue(ResultSet resultSet, String columnName) throws SQLException {
                return java.lang.Float.valueOf(resultSet.getFloat(columnName));
            }

            public Class getType() {
                return Float.class;
            }
        });
        bindings.put(Int, new DatabaseTypeBinding(){

            public Object getValue(ResultSet resultSet, String columnName) throws SQLException {
                return resultSet.getInt(columnName);
            }

            public Class getType() {
                return Integer.class;
            }
        });
        bindings.put(Long, new DatabaseTypeBinding(){

            public Object getValue(ResultSet resultSet, String columnName) throws SQLException {
                return resultSet.getLong(columnName);
            }

            public Class getType() {
                return Long.class;
            }
        });
        bindings.put(Short, new DatabaseTypeBinding(){

            public Object getValue(ResultSet resultSet, String columnName) throws SQLException {
                return resultSet.getShort(columnName);
            }

            public Class getType() {
                return Short.class;
            }
        });
        bindings.put(SqlDate, new DatabaseTypeBinding(){

            public Object getValue(ResultSet resultSet, String columnName) throws SQLException {
                return resultSet.getDate(columnName);
            }

            public Class getType() {
                return Date.class;
            }
        });
        bindings.put(SqlTime, new DatabaseTypeBinding(){

            public Object getValue(ResultSet resultSet, String columnName) throws SQLException {
                return resultSet.getTime(columnName);
            }

            public Class getType() {
                return Time.class;
            }
        });
        bindings.put(SqlTimestamp, new DatabaseTypeBinding(){

            public Object getValue(ResultSet resultSet, String columnName) throws SQLException {
                return resultSet.getTimestamp(columnName);
            }

            public Class getType() {
                return Timestamp.class;
            }
        });
    }
}

