/*
 * Decompiled with CFR 0.152.
 */
package net.esper.util;

import java.io.PrintWriter;
import net.esper.util.Indent;

public class IndentWriter {
    private final PrintWriter writer;
    private final int deltaIndent;
    private int currentIndent;

    public IndentWriter(PrintWriter writer, int startIndent, int deltaIndent) {
        if (startIndent < 0) {
            throw new IllegalArgumentException("Invalid start indent");
        }
        if (deltaIndent < 0) {
            throw new IllegalArgumentException("Invalid delta indent");
        }
        this.writer = writer;
        this.deltaIndent = deltaIndent;
        this.currentIndent = startIndent;
    }

    public void incrIndent() {
        this.currentIndent += this.deltaIndent;
    }

    public void decrIndent() {
        this.currentIndent -= this.deltaIndent;
    }

    public void println(String text) {
        int indent = this.currentIndent;
        if (indent < 0) {
            indent = 0;
        }
        this.writer.println(Indent.indent(indent) + text);
    }
}

