/*
 * Decompiled with CFR 0.152.
 */
package net.esper.util;

import java.util.concurrent.locks.ReentrantLock;
import net.esper.core.StatementLockFactory;
import net.esper.util.ManagedLock;
import net.esper.util.ThreadLogUtil;

public class ManagedLockImpl
implements ManagedLock {
    private final ReentrantLock lock;
    private final String name;

    public ManagedLockImpl(String name) {
        this.name = name;
        this.lock = new ReentrantLock();
    }

    public void acquireLock(StatementLockFactory statementLockFactory) {
        if (ThreadLogUtil.ENABLED_TRACE.booleanValue()) {
            ThreadLogUtil.traceLock("Acquire " + this.name, this.lock);
        }
        this.lock.lock();
        if (ThreadLogUtil.ENABLED_TRACE.booleanValue()) {
            ThreadLogUtil.traceLock("Got     " + this.name, this.lock);
        }
    }

    public void releaseLock(StatementLockFactory statementLockFactory) {
        if (ThreadLogUtil.ENABLED_TRACE.booleanValue()) {
            ThreadLogUtil.traceLock("Release " + this.name, this.lock);
        }
        this.lock.unlock();
        if (ThreadLogUtil.ENABLED_TRACE.booleanValue()) {
            ThreadLogUtil.traceLock("Freed   " + this.name, this.lock);
        }
    }

    public boolean isHeldByCurrentThread() {
        boolean isHeld = this.lock.isHeldByCurrentThread();
        if (ThreadLogUtil.ENABLED_TRACE.booleanValue()) {
            ThreadLogUtil.traceLock("Held    " + this.name + " by current:" + isHeld, this.lock);
        }
        return isHeld;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " name=" + this.name + " lock=" + this.lock;
    }
}

