/*
 * Decompiled with CFR 0.152.
 */
package net.esper.util;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.esper.util.ThreadLogUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ManagedReadWriteLock {
    private static final Log log = LogFactory.getLog(ManagedReadWriteLock.class);
    protected static final String ACQUIRE_TEXT = "Acquire ";
    protected static final String ACQUIRED_TEXT = "Got     ";
    protected static final String TRY_TEXT = "Trying  ";
    protected static final String RELEASE_TEXT = "Release ";
    protected static final String RELEASED_TEXT = "Freed   ";
    private final ReentrantReadWriteLock lock;
    private final String name;

    public ManagedReadWriteLock(String name, boolean isFair) {
        this.name = name;
        this.lock = new ReentrantReadWriteLock(isFair);
    }

    public void acquireWriteLock() {
        if (ThreadLogUtil.ENABLED_TRACE.booleanValue()) {
            ThreadLogUtil.traceLock("Acquire  write " + this.name, this.lock);
        }
        this.lock.writeLock().lock();
        if (ThreadLogUtil.ENABLED_TRACE.booleanValue()) {
            ThreadLogUtil.traceLock("Got      write " + this.name, this.lock);
        }
    }

    public boolean tryWriteLock(long msec) {
        if (ThreadLogUtil.ENABLED_TRACE.booleanValue()) {
            ThreadLogUtil.traceLock("Trying   write " + this.name, this.lock);
        }
        boolean result = false;
        try {
            result = this.lock.writeLock().tryLock(msec, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ex) {
            log.warn("Lock wait interupted");
        }
        if (ThreadLogUtil.ENABLED_TRACE.booleanValue()) {
            ThreadLogUtil.traceLock("Trying   write " + this.name + " : " + result, this.lock);
        }
        return result;
    }

    public void releaseWriteLock() {
        if (ThreadLogUtil.ENABLED_TRACE.booleanValue()) {
            ThreadLogUtil.traceLock("Release  write " + this.name, this.lock);
        }
        this.lock.writeLock().unlock();
        if (ThreadLogUtil.ENABLED_TRACE.booleanValue()) {
            ThreadLogUtil.traceLock("Freed    write " + this.name, this.lock);
        }
    }

    public void acquireReadLock() {
        if (ThreadLogUtil.ENABLED_TRACE.booleanValue()) {
            ThreadLogUtil.traceLock("Acquire  read " + this.name, this.lock);
        }
        this.lock.readLock().lock();
        if (ThreadLogUtil.ENABLED_TRACE.booleanValue()) {
            ThreadLogUtil.traceLock("Got      read " + this.name, this.lock);
        }
    }

    public void releaseReadLock() {
        if (ThreadLogUtil.ENABLED_TRACE.booleanValue()) {
            ThreadLogUtil.traceLock("Release  read " + this.name, this.lock);
        }
        this.lock.readLock().unlock();
        if (ThreadLogUtil.ENABLED_TRACE.booleanValue()) {
            ThreadLogUtil.traceLock("Freed    read " + this.name, this.lock);
        }
    }
}

