/*
 * Decompiled with CFR 0.152.
 */
package net.esper.util;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.esper.util.ExecutionPathDebugLog;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MethodResolver {
    private static final Log log = LogFactory.getLog(MethodResolver.class);
    private static final Map<Class, Set<Class>> wideningConversions = new HashMap<Class, Set<Class>>();
    private static final Map<Class, Set<Class>> wrappingConversions = new HashMap<Class, Set<Class>>();

    public static Method resolveMethod(Class declaringClass, String methodName, Class[] paramTypes, boolean allowInstance) throws NoSuchMethodException {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".resolve method className=" + declaringClass.getSimpleName() + ", methodName=" + methodName);
        }
        Method[] methods = declaringClass.getMethods();
        Method bestMatch = null;
        int bestConversionCount = -1;
        for (Method method : methods) {
            int conversionCount;
            if (!MethodResolver.isPublicAndStatic(method, allowInstance) || !method.getName().equals(methodName) || (conversionCount = MethodResolver.compareParameterTypes(method, paramTypes)) == -1) continue;
            if (conversionCount == 0) {
                bestMatch = method;
                break;
            }
            if (bestMatch == null) {
                bestMatch = method;
                bestConversionCount = conversionCount;
                continue;
            }
            if (conversionCount >= bestConversionCount) continue;
            bestMatch = method;
            bestConversionCount = conversionCount;
        }
        if (bestMatch != null) {
            return bestMatch;
        }
        StringBuffer params = new StringBuffer();
        if (paramTypes != null && paramTypes.length != 0) {
            String appendString = "";
            for (Class param : paramTypes) {
                params.append(appendString);
                params.append(((Object)param).toString());
                appendString = ", ";
            }
        }
        throw new NoSuchMethodException("Unknown method " + declaringClass.getSimpleName() + '.' + methodName + '(' + params + ')');
    }

    private static boolean isWideningConversion(Class declarationType, Class invocationType) {
        if (wideningConversions.containsKey(declarationType)) {
            return wideningConversions.get(declarationType).contains(invocationType);
        }
        return false;
    }

    private static boolean isPublicAndStatic(Method method, boolean allowInstance) {
        int modifiers = method.getModifiers();
        if (allowInstance) {
            return Modifier.isPublic(modifiers);
        }
        return Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers);
    }

    private static int compareParameterTypes(Method method, Class[] invocationParameters) {
        Class<?>[] declarationParameters = method.getParameterTypes();
        if (invocationParameters == null) {
            return declarationParameters.length == 0 ? 0 : -1;
        }
        if (declarationParameters.length != invocationParameters.length) {
            return -1;
        }
        int conversionCount = 0;
        int count = 0;
        for (Class<?> parameter : declarationParameters) {
            if (!MethodResolver.isIdentityConversion(parameter, invocationParameters[count])) {
                ++conversionCount;
                if (!MethodResolver.isWideningConversion(parameter, invocationParameters[count])) {
                    conversionCount = -1;
                    break;
                }
            }
            ++count;
        }
        return conversionCount;
    }

    private static boolean isIdentityConversion(Class declarationType, Class invocationType) {
        if (wrappingConversions.containsKey(declarationType)) {
            return wrappingConversions.get(declarationType).contains(invocationType) || declarationType.isAssignableFrom(invocationType);
        }
        return declarationType.isAssignableFrom(invocationType);
    }

    static {
        HashSet<Class<Boolean>> booleanWrappers = new HashSet<Class<Boolean>>();
        booleanWrappers.add(Boolean.TYPE);
        booleanWrappers.add(Boolean.class);
        wrappingConversions.put(Boolean.TYPE, booleanWrappers);
        wrappingConversions.put(Boolean.class, booleanWrappers);
        HashSet<Class<Character>> charWrappers = new HashSet<Class<Character>>();
        charWrappers.add(Character.TYPE);
        charWrappers.add(Character.class);
        wrappingConversions.put(Character.TYPE, charWrappers);
        wrappingConversions.put(Character.class, charWrappers);
        HashSet<Class<Byte>> byteWrappers = new HashSet<Class<Byte>>();
        byteWrappers.add(Byte.TYPE);
        byteWrappers.add(Byte.class);
        wrappingConversions.put(Byte.TYPE, byteWrappers);
        wrappingConversions.put(Byte.class, byteWrappers);
        HashSet<Class<Short>> shortWrappers = new HashSet<Class<Short>>();
        shortWrappers.add(Short.TYPE);
        shortWrappers.add(Short.class);
        wrappingConversions.put(Short.TYPE, shortWrappers);
        wrappingConversions.put(Short.class, shortWrappers);
        HashSet<Class<Integer>> intWrappers = new HashSet<Class<Integer>>();
        intWrappers.add(Integer.TYPE);
        intWrappers.add(Integer.class);
        wrappingConversions.put(Integer.TYPE, intWrappers);
        wrappingConversions.put(Integer.class, intWrappers);
        HashSet<Class<Long>> longWrappers = new HashSet<Class<Long>>();
        longWrappers.add(Long.TYPE);
        longWrappers.add(Long.class);
        wrappingConversions.put(Long.TYPE, longWrappers);
        wrappingConversions.put(Long.class, longWrappers);
        HashSet<Class<Float>> floatWrappers = new HashSet<Class<Float>>();
        floatWrappers.add(Float.TYPE);
        floatWrappers.add(Float.class);
        wrappingConversions.put(Float.TYPE, floatWrappers);
        wrappingConversions.put(Float.class, floatWrappers);
        HashSet<Class<Double>> doubleWrappers = new HashSet<Class<Double>>();
        doubleWrappers.add(Double.TYPE);
        doubleWrappers.add(Double.class);
        wrappingConversions.put(Double.TYPE, doubleWrappers);
        wrappingConversions.put(Double.class, doubleWrappers);
        HashSet<Class<Float>> wideningConversions = new HashSet<Class<Float>>(byteWrappers);
        MethodResolver.wideningConversions.put(Short.TYPE, new HashSet(wideningConversions));
        MethodResolver.wideningConversions.put(Short.class, new HashSet(wideningConversions));
        wideningConversions.addAll(shortWrappers);
        wideningConversions.addAll(charWrappers);
        MethodResolver.wideningConversions.put(Integer.TYPE, new HashSet(wideningConversions));
        MethodResolver.wideningConversions.put(Integer.class, new HashSet(wideningConversions));
        wideningConversions.addAll(intWrappers);
        MethodResolver.wideningConversions.put(Long.TYPE, new HashSet(wideningConversions));
        MethodResolver.wideningConversions.put(Long.class, new HashSet(wideningConversions));
        wideningConversions.addAll(longWrappers);
        MethodResolver.wideningConversions.put(Float.TYPE, new HashSet(wideningConversions));
        MethodResolver.wideningConversions.put(Float.class, new HashSet(wideningConversions));
        wideningConversions.addAll(floatWrappers);
        MethodResolver.wideningConversions.put(Double.TYPE, new HashSet(wideningConversions));
        MethodResolver.wideningConversions.put(Double.class, new HashSet(wideningConversions));
    }
}

