/*
 * Decompiled with CFR 0.152.
 */
package net.esper.util;

import java.util.Comparator;
import net.esper.collection.MultiKeyUntyped;
import net.esper.util.MetaDefItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MultiKeyComparator
implements Comparator<MultiKeyUntyped>,
MetaDefItem {
    private final Boolean[] isDescendingValues;

    public MultiKeyComparator(Boolean[] isDescendingValues) {
        this.isDescendingValues = isDescendingValues;
    }

    @Override
    public final int compare(MultiKeyUntyped firstValues, MultiKeyUntyped secondValues) {
        if (firstValues.size() != this.isDescendingValues.length || secondValues.size() != this.isDescendingValues.length) {
            throw new IllegalArgumentException("Incompatible size MultiKey sizes for comparison");
        }
        for (int i = 0; i < firstValues.size(); ++i) {
            boolean isDescending;
            Object valueTwo;
            Object valueOne = firstValues.get(i);
            int comparisonResult = MultiKeyComparator.compareValues(valueOne, valueTwo = secondValues.get(i), isDescending = this.isDescendingValues[i].booleanValue());
            if (comparisonResult == 0) continue;
            return comparisonResult;
        }
        if (!firstValues.equals(secondValues)) {
            return -1;
        }
        return 0;
    }

    private static int compareValues(Object valueOne, Object valueTwo, boolean isDescending) {
        if (isDescending) {
            Object temp = valueOne;
            valueOne = valueTwo;
            valueTwo = temp;
        }
        if (valueOne == null || valueTwo == null) {
            if (valueOne == null && valueTwo == null) {
                return 0;
            }
            if (valueOne == null) {
                return -1;
            }
            return 1;
        }
        if (!(valueOne instanceof Comparable)) {
            throw new ClassCastException("Cannot sort objects of type " + valueOne.getClass());
        }
        Comparable comparable1 = (Comparable)valueOne;
        return comparable1.compareTo(valueTwo);
    }
}

