/*
 * Decompiled with CFR 0.152.
 */
package net.esper.util;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.esper.util.PlaceholderParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlaceholderParser {
    public static List<Fragment> parsePlaceholder(String parseString) throws PlaceholderParseException {
        ArrayList<Fragment> result = new ArrayList<Fragment>();
        int currOutputIndex = 0;
        int currSearchIndex = 0;
        while (currSearchIndex != parseString.length()) {
            String textSoFar;
            int startIndex = parseString.indexOf("${", currSearchIndex);
            if (startIndex == -1) {
                if (currOutputIndex >= parseString.length()) break;
                String endString = parseString.substring(currOutputIndex, parseString.length());
                TextFragment textFragment = new TextFragment(endString);
                result.add(textFragment);
                break;
            }
            if (startIndex > 0 && (textSoFar = parseString.substring(currOutputIndex, startIndex)).length() != 0) {
                result.add(new TextFragment(textSoFar));
            }
            if (startIndex > 0 && parseString.charAt(startIndex - 1) == '$') {
                currOutputIndex = startIndex + 1;
                currSearchIndex = startIndex + 1;
                continue;
            }
            int endIndex = parseString.indexOf(125, startIndex);
            if (endIndex == -1) {
                throw new PlaceholderParseException("Syntax error in property: " + parseString.substring(startIndex, parseString.length()));
            }
            String between = parseString.substring(startIndex + 2, endIndex);
            ParameterFragment parameterFragment = new ParameterFragment(between);
            result.add(parameterFragment);
            currOutputIndex = endIndex + 1;
            currSearchIndex = endIndex;
        }
        LinkedList<Fragment> fragments = new LinkedList<Fragment>();
        fragments.add((Fragment)result.get(0));
        for (int i = 1; i < result.size(); ++i) {
            Fragment fragment = (Fragment)result.get(i);
            if (!(result.get(i) instanceof TextFragment)) {
                fragments.add(fragment);
                continue;
            }
            if (!(fragments.getLast() instanceof TextFragment)) {
                fragments.add(fragment);
                continue;
            }
            TextFragment textFragment = (TextFragment)fragments.getLast();
            fragments.removeLast();
            fragments.add(new TextFragment(textFragment.getValue() + fragment.getValue()));
        }
        return fragments;
    }

    public static class ParameterFragment
    extends Fragment {
        public ParameterFragment(String value) {
            super(value);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ParameterFragment)) {
                return false;
            }
            ParameterFragment other = (ParameterFragment)obj;
            return other.getValue().equals(this.getValue());
        }

        public boolean isParameter() {
            return true;
        }

        public String toString() {
            return "param=" + this.getValue();
        }
    }

    public static class TextFragment
    extends Fragment {
        public TextFragment(String value) {
            super(value);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TextFragment)) {
                return false;
            }
            TextFragment other = (TextFragment)obj;
            return other.getValue().equals(this.getValue());
        }

        public String toString() {
            return "text=" + this.getValue();
        }

        public boolean isParameter() {
            return false;
        }
    }

    public static abstract class Fragment {
        private String value;

        protected Fragment(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public abstract boolean isParameter();

        public int hashCode() {
            return this.value != null ? this.value.hashCode() : 0;
        }
    }
}

