/*
 * Decompiled with CFR 0.152.
 */
package net.esper.util;

import java.net.MalformedURLException;
import java.net.URL;
import net.esper.client.EPException;

public class ResourceLoader {
    public static URL resolveClassPathOrURLResource(String resourceName, String urlOrClasspathResource) {
        URL url = null;
        try {
            url = new URL(urlOrClasspathResource);
        }
        catch (MalformedURLException ex) {
            url = ResourceLoader.getClasspathResourceAsURL(resourceName, urlOrClasspathResource);
        }
        return url;
    }

    protected static URL getClasspathResourceAsURL(String resourceName, String resource) {
        String stripped = resource.startsWith("/") ? resource.substring(1) : resource;
        URL url = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            url = classLoader.getResource(stripped);
        }
        if (url == null) {
            ResourceLoader.class.getResource(resource);
        }
        if (url == null) {
            url = ResourceLoader.class.getClassLoader().getResource(stripped);
        }
        if (url == null) {
            throw new EPException(resourceName + " resource '" + resource + "' not found");
        }
        return url;
    }
}

