/*
 * Decompiled with CFR 0.152.
 */
package net.esper.util;

import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;

public class SQLTypeMapUtil {
    public static Class sqlTypeToClass(int sqlType, String className) {
        if (sqlType == 16 || sqlType == -7) {
            return Boolean.class;
        }
        if (sqlType == 1 || sqlType == 12 || sqlType == -1) {
            return String.class;
        }
        if (sqlType == 1 || sqlType == 12) {
            return String.class;
        }
        if (sqlType == 8 || sqlType == 6) {
            return Double.class;
        }
        if (sqlType == 7) {
            return Float.class;
        }
        if (sqlType == 4) {
            return Integer.class;
        }
        if (sqlType == -5) {
            return Long.class;
        }
        if (sqlType == -6) {
            return Byte.class;
        }
        if (sqlType == 5) {
            return Short.class;
        }
        if (sqlType == 2 || sqlType == 3) {
            return BigDecimal.class;
        }
        if (sqlType == -2 || sqlType == -3 || sqlType == -4) {
            return byte[].class;
        }
        if (sqlType == 91) {
            return Date.class;
        }
        if (sqlType == 92) {
            return Time.class;
        }
        if (sqlType == 93) {
            return Timestamp.class;
        }
        if (sqlType == 2005) {
            return Clob.class;
        }
        if (sqlType == 2004) {
            return Blob.class;
        }
        if (sqlType == 2003) {
            return Array.class;
        }
        if (sqlType == 2002) {
            return Struct.class;
        }
        if (sqlType == 2006) {
            return Ref.class;
        }
        if (sqlType == 70) {
            return URL.class;
        }
        if (sqlType == 2000 || sqlType == 2001) {
            if (className == null) {
                throw new IllegalArgumentException("No class supplied for sql type " + sqlType);
            }
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Cannot load class for sql type " + sqlType + " and class " + className);
            }
        }
        throw new IllegalArgumentException("Cannot map java.sql.Types type " + sqlType);
    }
}

