/*
 * Decompiled with CFR 0.152.
 */
package net.esper.view;

import java.util.Map;
import net.esper.collection.Pair;
import net.esper.eql.spec.PluggableObjectCollection;
import net.esper.eql.spec.PluggableObjectType;
import net.esper.view.ViewFactory;
import net.esper.view.ViewProcessingException;
import net.esper.view.ViewResolutionService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ViewResolutionServiceImpl
implements ViewResolutionService {
    private static final Log log = LogFactory.getLog(ViewResolutionServiceImpl.class);
    private final PluggableObjectCollection viewObjects;

    public ViewResolutionServiceImpl(PluggableObjectCollection viewObjects) {
        this.viewObjects = viewObjects;
    }

    public ViewFactory create(String nameSpace, String name) throws ViewProcessingException {
        ViewFactory viewFactory;
        Pair<Class, PluggableObjectType> pair;
        if (log.isDebugEnabled()) {
            log.debug(".create Creating view factory, namespace=" + nameSpace + " name=" + name);
        }
        Class viewFactoryClass = null;
        Map<String, Pair<Class, PluggableObjectType>> namespaceMap = this.viewObjects.getPluggables().get(nameSpace);
        if (namespaceMap != null && (pair = namespaceMap.get(name)) != null) {
            if (pair.getSecond() == PluggableObjectType.VIEW) {
                viewFactoryClass = pair.getFirst();
            } else {
                throw new ViewProcessingException("Invalid object type '" + (Object)((Object)pair.getSecond()) + "' for view '" + name + "'");
            }
        }
        if (viewFactoryClass == null) {
            String message = "View name '" + nameSpace + ":" + name + "' is not a known view name";
            throw new ViewProcessingException(message);
        }
        try {
            viewFactory = (ViewFactory)viewFactoryClass.newInstance();
            if (log.isDebugEnabled()) {
                log.debug(".create Successfully instantiated view");
            }
        }
        catch (ClassCastException e) {
            String message = "Error casting view factory instance to " + ViewFactory.class.getName() + " interface for view '" + name + "'";
            throw new ViewProcessingException(message, e);
        }
        catch (IllegalAccessException e) {
            String message = "Error invoking view factory constructor for view '" + name;
            message = message + "', no invocation access for Class.newInstance";
            throw new ViewProcessingException(message, e);
        }
        catch (InstantiationException e) {
            String message = "Error invoking view factory constructor for view '" + name;
            message = message + "' using Class.newInstance";
            throw new ViewProcessingException(message, e);
        }
        return viewFactory;
    }
}

