/*
 * Decompiled with CFR 0.152.
 */
package net.esper.view;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.esper.collection.Pair;
import net.esper.core.StatementContext;
import net.esper.eql.spec.ViewSpec;
import net.esper.event.EventType;
import net.esper.view.EventStream;
import net.esper.view.InitializableView;
import net.esper.view.View;
import net.esper.view.ViewAttachException;
import net.esper.view.ViewFactory;
import net.esper.view.ViewFactoryChain;
import net.esper.view.ViewProcessingException;
import net.esper.view.ViewService;
import net.esper.view.ViewServiceHelper;
import net.esper.view.ViewSupport;
import net.esper.view.Viewable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ViewServiceImpl
implements ViewService {
    private static final Log log = LogFactory.getLog(ViewServiceImpl.class);

    @Override
    public ViewFactoryChain createFactories(int streamNum, EventType parentEventType, List<ViewSpec> viewSpecDefinitions, StatementContext context) throws ViewProcessingException {
        ArrayList<ViewSpec> viewSpecList = new ArrayList<ViewSpec>(viewSpecDefinitions);
        ViewServiceHelper.addMergeViews(viewSpecList);
        List<ViewFactory> viewFactories = ViewServiceHelper.instantiateFactories(streamNum, viewSpecList, context);
        ViewFactory parentViewFactory = null;
        LinkedList<ViewFactory> attachedViewFactories = new LinkedList<ViewFactory>();
        for (int i = 0; i < viewFactories.size(); ++i) {
            ViewFactory factoryToAttach = viewFactories.get(i);
            try {
                factoryToAttach.attach(parentEventType, context, parentViewFactory, attachedViewFactories);
                attachedViewFactories.add(viewFactories.get(i));
                parentEventType = factoryToAttach.getEventType();
                continue;
            }
            catch (ViewAttachException ex) {
                String text = "Error attaching view to parent view";
                if (i == 0) {
                    text = "Error attaching view to event stream";
                }
                throw new ViewProcessingException(text + ": " + ex.getMessage(), ex);
            }
        }
        return new ViewFactoryChain(parentEventType, viewFactories);
    }

    @Override
    public Viewable createViews(Viewable eventStreamViewable, List<ViewFactory> viewFactories, StatementContext context) {
        Pair<Viewable, List<View>> resultPair = ViewServiceHelper.matchExistingViews(eventStreamViewable, viewFactories);
        Viewable parentViewable = resultPair.getFirst();
        if (viewFactories.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug(".createView No new views created, dumping stream ... " + eventStreamViewable);
                ViewSupport.dumpChildViews("EventStream ", eventStreamViewable);
            }
            return parentViewable;
        }
        List<View> views = ViewServiceHelper.instantiateChain(parentViewable, viewFactories, context);
        for (View view : views) {
            if (!(view instanceof InitializableView)) continue;
            InitializableView initView = (InitializableView)((Object)view);
            initView.initialize();
        }
        if (log.isDebugEnabled()) {
            log.debug(".createView New views created for stream, all views ... " + eventStreamViewable);
            ViewSupport.dumpChildViews("EventStream ", eventStreamViewable);
        }
        return views.get(views.size() - 1);
    }

    @Override
    public void remove(EventStream eventStream, Viewable viewToRemove) {
        if (viewToRemove.hasViews()) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(".remove Views before the remove of view " + viewToRemove + ", for event stream " + eventStream);
            ViewSupport.dumpChildViews("EventStream ", eventStream);
        }
        ViewServiceHelper.removeChainLeafView(eventStream, viewToRemove);
        if (log.isDebugEnabled()) {
            log.debug(".remove Views after the remove, for event stream " + eventStream);
            ViewSupport.dumpChildViews("EventStream ", eventStream);
        }
    }
}

