/*
 * Decompiled with CFR 0.152.
 */
package net.esper.view;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.esper.collection.SingleEventIterator;
import net.esper.event.EventBean;
import net.esper.event.EventType;
import net.esper.util.ExecutionPathDebugLog;
import net.esper.view.EventStream;
import net.esper.view.View;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ZeroDepthStream
implements EventStream {
    private final LinkedList<View> children = new LinkedList();
    private final EventType eventType;
    private EventBean lastInsertedEvent;
    private static final Log log = LogFactory.getLog(ZeroDepthStream.class);

    public ZeroDepthStream(EventType eventType) {
        this.eventType = eventType;
    }

    @Override
    public final void insert(EventBean event) {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".insert Received event, updating child views, event=" + event);
        }
        EventBean[] row = new EventBean[]{event};
        for (View childView : this.children) {
            childView.update(row, null);
        }
        this.lastInsertedEvent = event;
    }

    @Override
    public final EventType getEventType() {
        return this.eventType;
    }

    @Override
    public final Iterator<EventBean> iterator() {
        return new SingleEventIterator(this.lastInsertedEvent);
    }

    @Override
    public final View addView(View view) {
        this.children.add(view);
        view.setParent(this);
        return view;
    }

    @Override
    public final List<View> getViews() {
        return this.children;
    }

    @Override
    public final boolean removeView(View view) {
        boolean isRemoved = this.children.remove(view);
        view.setParent(null);
        return isRemoved;
    }

    @Override
    public final boolean hasViews() {
        return !this.children.isEmpty();
    }
}

