/*
 * Decompiled with CFR 0.152.
 */
package net.esper.view.ext;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import net.esper.collection.MultiKeyUntyped;
import net.esper.event.EventBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SortWindowIterator
implements Iterator<EventBean> {
    private final SortedMap<MultiKeyUntyped, LinkedList<EventBean>> window;
    private final Iterator<MultiKeyUntyped> keyIterator;
    private Iterator<EventBean> currentListIterator;

    public SortWindowIterator(SortedMap<MultiKeyUntyped, LinkedList<EventBean>> window) {
        this.window = window;
        this.keyIterator = window.keySet().iterator();
        if (this.keyIterator.hasNext()) {
            MultiKeyUntyped initialKey = this.keyIterator.next();
            this.currentListIterator = ((LinkedList)window.get(initialKey)).iterator();
        }
    }

    @Override
    public final EventBean next() {
        if (this.currentListIterator == null) {
            throw new NoSuchElementException();
        }
        EventBean eventBean = this.currentListIterator.next();
        if (!this.currentListIterator.hasNext()) {
            this.currentListIterator = null;
            if (this.keyIterator.hasNext()) {
                MultiKeyUntyped nextKey = this.keyIterator.next();
                this.currentListIterator = ((LinkedList)this.window.get(nextKey)).iterator();
            }
        }
        return eventBean;
    }

    @Override
    public final boolean hasNext() {
        if (this.currentListIterator == null) {
            return false;
        }
        if (this.currentListIterator.hasNext()) {
            return true;
        }
        this.currentListIterator = null;
        return this.keyIterator.hasNext();
    }

    @Override
    public final void remove() {
        throw new UnsupportedOperationException();
    }
}

