/*
 * Decompiled with CFR 0.152.
 */
package net.esper.view.ext;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeMap;
import net.esper.collection.MultiKeyUntyped;
import net.esper.core.StatementContext;
import net.esper.event.EventBean;
import net.esper.event.EventPropertyGetter;
import net.esper.event.EventType;
import net.esper.util.ExecutionPathDebugLog;
import net.esper.util.MultiKeyComparator;
import net.esper.view.CloneableView;
import net.esper.view.DataWindowView;
import net.esper.view.View;
import net.esper.view.ViewSupport;
import net.esper.view.Viewable;
import net.esper.view.ext.IStreamSortedRandomAccess;
import net.esper.view.ext.SortWindowIterator;
import net.esper.view.ext.SortWindowViewFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SortWindowView
extends ViewSupport
implements DataWindowView,
CloneableView {
    private final SortWindowViewFactory sortWindowViewFactory;
    private final String[] sortFieldNames;
    private final Boolean[] isDescendingValues;
    private final int sortWindowSize;
    private final IStreamSortedRandomAccess optionalSortedRandomAccess;
    private EventPropertyGetter[] sortFieldGetters;
    private TreeMap<MultiKeyUntyped, LinkedList<EventBean>> sortedEvents;
    private int eventCount;
    private static final Log log = LogFactory.getLog(SortWindowView.class);

    public SortWindowView(SortWindowViewFactory sortWindowViewFactory, String[] sortFieldNames, Boolean[] descendingValues, int sortWindowSize, IStreamSortedRandomAccess optionalSortedRandomAccess) {
        this.sortWindowViewFactory = sortWindowViewFactory;
        this.sortFieldNames = sortFieldNames;
        this.isDescendingValues = descendingValues;
        this.sortWindowSize = sortWindowSize;
        this.optionalSortedRandomAccess = optionalSortedRandomAccess;
        MultiKeyComparator comparator = new MultiKeyComparator(this.isDescendingValues);
        this.sortedEvents = new TreeMap(comparator);
    }

    @Override
    public void setParent(Viewable parent) {
        super.setParent(parent);
        if (parent != null) {
            int count = 0;
            this.sortFieldGetters = new EventPropertyGetter[this.sortFieldNames.length];
            for (String name : this.sortFieldNames) {
                this.sortFieldGetters[count++] = parent.getEventType().getGetter(name);
            }
        }
    }

    protected final String[] getSortFieldNames() {
        return this.sortFieldNames;
    }

    protected final Boolean[] getIsDescendingValues() {
        return this.isDescendingValues;
    }

    protected final int getSortWindowSize() {
        return this.sortWindowSize;
    }

    protected IStreamSortedRandomAccess getOptionalSortedRandomAccess() {
        return this.optionalSortedRandomAccess;
    }

    @Override
    public View cloneView(StatementContext statementContext) {
        return this.sortWindowViewFactory.makeView(statementContext);
    }

    @Override
    public final EventType getEventType() {
        return this.parent.getEventType();
    }

    @Override
    public final void update(EventBean[] newData, EventBean[] oldData) {
        MultiKeyUntyped sortValues;
        int i;
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".update Updating view");
            SortWindowView.dumpUpdateParams("SortWindowView", newData, oldData);
        }
        LinkedList<EventBean> removedEvents = new LinkedList<EventBean>();
        if (oldData != null) {
            for (i = 0; i < oldData.length; ++i) {
                sortValues = this.getSortValues(oldData[i]);
                boolean result = this.remove(sortValues, oldData[i]);
                if (!result) continue;
                --this.eventCount;
                removedEvents.add(oldData[i]);
            }
        }
        if (newData != null) {
            for (i = 0; i < newData.length; ++i) {
                sortValues = this.getSortValues(newData[i]);
                this.add(sortValues, newData[i]);
                ++this.eventCount;
            }
        }
        if (this.eventCount > this.sortWindowSize) {
            int removeCount = this.eventCount - this.sortWindowSize;
            for (int i2 = 0; i2 < removeCount; ++i2) {
                MultiKeyUntyped lastKey = this.sortedEvents.lastKey();
                LinkedList<EventBean> events = this.sortedEvents.get(lastKey);
                EventBean event = events.removeLast();
                --this.eventCount;
                if (events.isEmpty()) {
                    this.sortedEvents.remove(lastKey);
                }
                removedEvents.add(event);
                if (!ExecutionPathDebugLog.isDebugEnabled || !log.isDebugEnabled()) continue;
                log.debug(".update Pushing out event event=" + event);
            }
        }
        if (this.optionalSortedRandomAccess != null) {
            this.optionalSortedRandomAccess.refresh(this.sortedEvents, this.eventCount, this.sortWindowSize);
        }
        if (this.hasViews()) {
            EventBean[] expiredArr = null;
            if (!removedEvents.isEmpty()) {
                expiredArr = removedEvents.toArray(new EventBean[0]);
            }
            this.updateChildren(newData, expiredArr);
        }
    }

    @Override
    public final Iterator<EventBean> iterator() {
        return new SortWindowIterator(this.sortedEvents);
    }

    public final String toString() {
        return this.getClass().getName() + " sortFieldName=" + Arrays.toString(this.sortFieldNames) + " isDescending=" + Arrays.toString((Object[])this.isDescendingValues) + " sortWindowSize=" + this.sortWindowSize;
    }

    private void add(MultiKeyUntyped key, EventBean bean) {
        LinkedList<EventBean> listOfBeans = this.sortedEvents.get(key);
        if (listOfBeans != null) {
            listOfBeans.addFirst(bean);
            return;
        }
        listOfBeans = new LinkedList();
        listOfBeans.add(bean);
        this.sortedEvents.put(key, listOfBeans);
    }

    private boolean remove(MultiKeyUntyped key, EventBean bean) {
        LinkedList<EventBean> listOfBeans = this.sortedEvents.get(key);
        if (listOfBeans == null) {
            return false;
        }
        boolean result = listOfBeans.remove(bean);
        if (listOfBeans.isEmpty()) {
            this.sortedEvents.remove(key);
        }
        return result;
    }

    private MultiKeyUntyped getSortValues(EventBean event) {
        Object[] result = new Object[this.sortFieldGetters.length];
        int count = 0;
        for (EventPropertyGetter getter : this.sortFieldGetters) {
            result[count++] = getter.get(event);
        }
        return new MultiKeyUntyped(result);
    }

    public boolean isEmpty() {
        return this.sortedEvents.isEmpty();
    }
}

