/*
 * Decompiled with CFR 0.152.
 */
package net.esper.view.ext;

import java.util.Arrays;
import java.util.List;
import net.esper.core.StatementContext;
import net.esper.eql.core.ViewResourceCallback;
import net.esper.eql.named.RemoveStreamViewCapability;
import net.esper.event.EventType;
import net.esper.util.JavaClassHelper;
import net.esper.view.DataWindowViewFactory;
import net.esper.view.PropertyCheckHelper;
import net.esper.view.View;
import net.esper.view.ViewAttachException;
import net.esper.view.ViewCapDataWindowAccess;
import net.esper.view.ViewCapability;
import net.esper.view.ViewFactory;
import net.esper.view.ViewFactoryContext;
import net.esper.view.ViewParameterException;
import net.esper.view.ext.IStreamSortedRandomAccess;
import net.esper.view.ext.SortWindowView;
import net.esper.view.window.RandomAccessByIndexGetter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortWindowViewFactory
implements DataWindowViewFactory {
    protected String[] sortFieldNames;
    protected Boolean[] isDescendingValues;
    protected int sortWindowSize;
    protected RandomAccessByIndexGetter randomAccessGetterImpl;
    private EventType eventType;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setViewParameters(ViewFactoryContext viewFactoryContext, List<Object> viewParameters) throws ViewParameterException {
        String errorMessage = "Sort window view requires a field name, a boolean sort order and a numeric size parameter or parameter list";
        if (viewParameters.size() == 3) {
            if (!(viewParameters.get(0) instanceof String) || !(viewParameters.get(1) instanceof Boolean) || !(viewParameters.get(2) instanceof Number)) throw new ViewParameterException(errorMessage);
            this.sortFieldNames = new String[]{(String)viewParameters.get(0)};
            this.isDescendingValues = new Boolean[]{(Boolean)viewParameters.get(1)};
            Number sizeParam = (Number)viewParameters.get(2);
            if (JavaClassHelper.isFloatingPointNumber(sizeParam)) {
                throw new ViewParameterException(errorMessage);
            }
            this.sortWindowSize = sizeParam.intValue();
        } else {
            if (viewParameters.size() != 2) throw new ViewParameterException(errorMessage);
            if (!(viewParameters.get(0) instanceof Object[]) || !(viewParameters.get(1) instanceof Integer)) {
                throw new ViewParameterException(errorMessage);
            }
            Object[] ascFieldsArr = (Object[])viewParameters.get(0);
            try {
                this.setNamesAndIsDescendingValues(ascFieldsArr);
            }
            catch (RuntimeException ex) {
                throw new ViewParameterException(errorMessage + ",reason:" + ex.getMessage());
            }
            Number sizeParam = (Number)viewParameters.get(1);
            if (JavaClassHelper.isFloatingPointNumber(sizeParam)) {
                throw new ViewParameterException(errorMessage);
            }
            this.sortWindowSize = sizeParam.intValue();
        }
        if (this.sortWindowSize >= 1) return;
        throw new ViewParameterException("Illegal argument for sort window size of sort window");
    }

    @Override
    public void attach(EventType parentEventType, StatementContext statementContext, ViewFactory optionalParentFactory, List<ViewFactory> parentViewFactories) throws ViewAttachException {
        String result = null;
        for (String name : this.sortFieldNames) {
            result = PropertyCheckHelper.exists(parentEventType, name);
            if (result == null) continue;
            throw new ViewAttachException(result);
        }
        this.eventType = parentEventType;
    }

    @Override
    public boolean canProvideCapability(ViewCapability viewCapability) {
        if (viewCapability instanceof RemoveStreamViewCapability) {
            return true;
        }
        return viewCapability instanceof ViewCapDataWindowAccess;
    }

    @Override
    public void setProvideCapability(ViewCapability viewCapability, ViewResourceCallback resourceCallback) {
        if (!this.canProvideCapability(viewCapability)) {
            throw new UnsupportedOperationException("View capability " + viewCapability.getClass().getSimpleName() + " not supported");
        }
        if (viewCapability instanceof RemoveStreamViewCapability) {
            return;
        }
        if (this.randomAccessGetterImpl == null) {
            this.randomAccessGetterImpl = new RandomAccessByIndexGetter();
        }
        resourceCallback.setViewResource(this.randomAccessGetterImpl);
    }

    @Override
    public View makeView(StatementContext statementContext) {
        IStreamSortedRandomAccess sortedRandomAccess = null;
        if (this.randomAccessGetterImpl != null) {
            sortedRandomAccess = new IStreamSortedRandomAccess(this.randomAccessGetterImpl);
            this.randomAccessGetterImpl.updated(sortedRandomAccess);
        }
        return new SortWindowView(this, this.sortFieldNames, this.isDescendingValues, this.sortWindowSize, sortedRandomAccess);
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public boolean canReuse(View view) {
        if (this.randomAccessGetterImpl != null) {
            return false;
        }
        if (!(view instanceof SortWindowView)) {
            return false;
        }
        SortWindowView other = (SortWindowView)view;
        if (other.getSortWindowSize() != this.sortWindowSize || !Arrays.deepEquals(other.getIsDescendingValues(), this.isDescendingValues) || !Arrays.deepEquals(other.getSortFieldNames(), this.sortFieldNames)) {
            return false;
        }
        return other.isEmpty();
    }

    private void setNamesAndIsDescendingValues(Object[] propertiesAndDirections) {
        if (propertiesAndDirections.length % 2 != 0) {
            throw new IllegalArgumentException("Each property to sort by must have an isDescending boolean qualifier");
        }
        int length = propertiesAndDirections.length / 2;
        this.sortFieldNames = new String[length];
        this.isDescendingValues = new Boolean[length];
        for (int i = 0; i < length; ++i) {
            this.sortFieldNames[i] = (String)propertiesAndDirections[2 * i];
            this.isDescendingValues[i] = (Boolean)propertiesAndDirections[2 * i + 1];
        }
    }
}

