/*
 * Decompiled with CFR 0.152.
 */
package net.esper.view.ext;

import java.util.List;
import net.esper.core.StatementContext;
import net.esper.eql.core.ViewResourceCallback;
import net.esper.eql.named.RemoveStreamViewCapability;
import net.esper.event.EventType;
import net.esper.type.TimePeriodParameter;
import net.esper.util.JavaClassHelper;
import net.esper.view.DataWindowViewFactory;
import net.esper.view.PropertyCheckHelper;
import net.esper.view.View;
import net.esper.view.ViewAttachException;
import net.esper.view.ViewCapDataWindowAccess;
import net.esper.view.ViewCapability;
import net.esper.view.ViewFactory;
import net.esper.view.ViewFactoryContext;
import net.esper.view.ViewParameterException;
import net.esper.view.ext.IStreamTimeOrderRandomAccess;
import net.esper.view.ext.TimeOrderView;
import net.esper.view.window.RandomAccessByIndexGetter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeOrderViewFactory
implements DataWindowViewFactory {
    protected String timestampFieldName;
    protected long intervalSize;
    protected RandomAccessByIndexGetter randomAccessGetterImpl;
    protected boolean isRemoveStreamHandling;
    private EventType eventType;

    @Override
    public void setViewParameters(ViewFactoryContext viewFactoryContext, List<Object> viewParameters) throws ViewParameterException {
        String errorMessage = "Time order view requires the property name supplying timestamp values, and a numeric or time period parameter for interval size";
        if (viewParameters.size() != 2) {
            throw new ViewParameterException(errorMessage);
        }
        if (!(viewParameters.get(0) instanceof String)) {
            throw new ViewParameterException(errorMessage);
        }
        this.timestampFieldName = (String)viewParameters.get(0);
        Object parameter = viewParameters.get(1);
        if (parameter instanceof TimePeriodParameter) {
            TimePeriodParameter param = (TimePeriodParameter)parameter;
            this.intervalSize = Math.round(1000.0 * param.getNumSeconds());
        } else {
            if (!(parameter instanceof Number)) {
                throw new ViewParameterException(errorMessage);
            }
            Number param = (Number)parameter;
            this.intervalSize = JavaClassHelper.isFloatingPointNumber(param) ? Math.round(1000.0 * param.doubleValue()) : 1000L * param.longValue();
        }
        if (this.intervalSize < 100L) {
            throw new ViewParameterException("Time order view requires a size of at least 100 msec");
        }
    }

    @Override
    public void attach(EventType parentEventType, StatementContext statementContext, ViewFactory optionalParentFactory, List<ViewFactory> parentViewFactories) throws ViewAttachException {
        String result = PropertyCheckHelper.exists(parentEventType, this.timestampFieldName);
        if (result != null) {
            throw new ViewAttachException(result);
        }
        this.eventType = parentEventType;
    }

    @Override
    public boolean canProvideCapability(ViewCapability viewCapability) {
        if (viewCapability instanceof ViewCapDataWindowAccess) {
            return true;
        }
        return viewCapability instanceof RemoveStreamViewCapability;
    }

    @Override
    public void setProvideCapability(ViewCapability viewCapability, ViewResourceCallback resourceCallback) {
        if (!this.canProvideCapability(viewCapability)) {
            throw new UnsupportedOperationException("View capability " + viewCapability.getClass().getSimpleName() + " not supported");
        }
        if (viewCapability instanceof RemoveStreamViewCapability) {
            this.isRemoveStreamHandling = true;
            return;
        }
        if (this.randomAccessGetterImpl == null) {
            this.randomAccessGetterImpl = new RandomAccessByIndexGetter();
        }
        resourceCallback.setViewResource(this.randomAccessGetterImpl);
    }

    @Override
    public View makeView(StatementContext statementContext) {
        IStreamTimeOrderRandomAccess sortedRandomAccess = null;
        if (this.randomAccessGetterImpl != null) {
            sortedRandomAccess = new IStreamTimeOrderRandomAccess(this.randomAccessGetterImpl);
            this.randomAccessGetterImpl.updated(sortedRandomAccess);
        }
        return new TimeOrderView(statementContext, this, this.timestampFieldName, this.intervalSize, sortedRandomAccess, this.isRemoveStreamHandling);
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public boolean canReuse(View view) {
        if (this.randomAccessGetterImpl != null) {
            return false;
        }
        if (!(view instanceof TimeOrderView)) {
            return false;
        }
        TimeOrderView other = (TimeOrderView)view;
        if (other.getIntervalSize() != this.intervalSize || !other.getTimestampFieldName().equals(this.timestampFieldName)) {
            return false;
        }
        return other.isEmpty();
    }
}

