/*
 * Decompiled with CFR 0.152.
 */
package net.esper.view.internal;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.esper.collection.RollingEventBuffer;
import net.esper.collection.ViewUpdatedCollection;
import net.esper.event.EventBean;
import net.esper.view.window.RelativeAccessByEventNIndex;

public class PriorEventBufferMulti
implements ViewUpdatedCollection,
RelativeAccessByEventNIndex {
    private final int priorToIndexesSize;
    private final int[] priorToIndexes;
    private final Map<EventBean, EventBean[]> priorEventMap;
    private final RollingEventBuffer newEvents;
    private EventBean[] lastOldData;

    public PriorEventBufferMulti(int[] priorToIndexSet) {
        int maxPriorIndex = 0;
        int[] arr$ = priorToIndexSet;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Integer priorIndex = arr$[i$];
            if (priorIndex <= maxPriorIndex) continue;
            maxPriorIndex = priorIndex;
        }
        this.priorToIndexesSize = priorToIndexSet.length;
        this.priorToIndexes = new int[this.priorToIndexesSize];
        int count = 0;
        int[] arr$2 = priorToIndexSet;
        int len$2 = arr$2.length;
        for (int i$ = 0; i$ < len$2; ++i$) {
            Integer priorIndex = arr$2[i$];
            this.priorToIndexes[count++] = priorIndex;
        }
        Arrays.sort(this.priorToIndexes);
        this.newEvents = new RollingEventBuffer(maxPriorIndex + 1);
        this.priorEventMap = new HashMap<EventBean, EventBean[]>();
    }

    public void update(EventBean[] newData, EventBean[] oldData) {
        int i;
        if (this.lastOldData != null) {
            for (i = 0; i < this.lastOldData.length; ++i) {
                this.priorEventMap.remove(this.lastOldData[i]);
            }
        }
        if (newData != null) {
            for (i = 0; i < newData.length; ++i) {
                EventBean newEvent = newData[i];
                this.newEvents.add(newEvent);
                EventBean[] priorEvents = new EventBean[this.priorToIndexesSize];
                for (int j = 0; j < this.priorToIndexesSize; ++j) {
                    int priorIndex = this.priorToIndexes[j];
                    priorEvents[j] = this.newEvents.get(priorIndex);
                }
                this.priorEventMap.put(newEvent, priorEvents);
            }
        }
        this.lastOldData = oldData;
    }

    public EventBean getRelativeToEvent(EventBean event, int priorToIndex) {
        if (priorToIndex >= this.priorToIndexesSize) {
            throw new IllegalArgumentException("Index " + priorToIndex + " not allowed, max size is " + this.priorToIndexesSize);
        }
        EventBean[] priorEvents = this.priorEventMap.get(event);
        if (priorEvents == null) {
            throw new IllegalStateException("Event not currently in collection, event=" + event);
        }
        return priorEvents[priorToIndex];
    }

    public void destroy() {
    }
}

