/*
 * Decompiled with CFR 0.152.
 */
package net.esper.view.internal;

import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import net.esper.collection.ViewUpdatedCollection;
import net.esper.core.StatementContext;
import net.esper.eql.core.ViewResourceCallback;
import net.esper.event.EventBean;
import net.esper.event.EventType;
import net.esper.view.View;
import net.esper.view.ViewAttachException;
import net.esper.view.ViewCapPriorEventAccess;
import net.esper.view.ViewCapability;
import net.esper.view.ViewFactory;
import net.esper.view.ViewFactoryContext;
import net.esper.view.ViewParameterException;
import net.esper.view.internal.PriorEventBufferMulti;
import net.esper.view.internal.PriorEventBufferSingle;
import net.esper.view.internal.PriorEventBufferUnbound;
import net.esper.view.internal.PriorEventView;
import net.esper.view.window.RelativeAccessByEventNIndex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PriorEventViewFactory
implements ViewFactory {
    protected TreeMap<Integer, List<ViewResourceCallback>> callbacksPerIndex = new TreeMap();
    private EventType eventType;
    protected boolean isUnbound;

    @Override
    public void setViewParameters(ViewFactoryContext viewFactoryContext, List<Object> viewParameters) throws ViewParameterException {
        if (viewParameters.size() != 1) {
            throw new ViewParameterException("View requires a single parameter indicating unbound or not");
        }
        this.isUnbound = (Boolean)viewParameters.get(0);
    }

    @Override
    public void attach(EventType parentEventType, StatementContext statementContext, ViewFactory optionalParentFactory, List<ViewFactory> parentViewFactories) throws ViewAttachException {
        this.eventType = parentEventType;
    }

    @Override
    public boolean canProvideCapability(ViewCapability viewCapability) {
        return viewCapability instanceof ViewCapPriorEventAccess;
    }

    @Override
    public void setProvideCapability(ViewCapability viewCapability, ViewResourceCallback resourceCallback) {
        if (!this.canProvideCapability(viewCapability)) {
            throw new UnsupportedOperationException("View capability " + viewCapability.getClass().getSimpleName() + " not supported");
        }
        ViewCapPriorEventAccess requested = (ViewCapPriorEventAccess)viewCapability;
        int reqIndex = requested.getIndexConstant();
        List<ViewResourceCallback> callbackList = this.callbacksPerIndex.get(reqIndex);
        if (callbackList == null) {
            callbackList = new LinkedList<ViewResourceCallback>();
            this.callbacksPerIndex.put(reqIndex, callbackList);
        }
        callbackList.add(resourceCallback);
    }

    @Override
    public View makeView(StatementContext statementContext) {
        ViewUpdatedCollection viewUpdatedCollection = null;
        if (this.callbacksPerIndex.isEmpty()) {
            throw new IllegalStateException("No resources requested");
        }
        int[] requested = new int[this.callbacksPerIndex.size()];
        int count = 0;
        for (int reqIndex : this.callbacksPerIndex.keySet()) {
            requested[count++] = reqIndex;
        }
        viewUpdatedCollection = this.isUnbound ? new PriorEventBufferUnbound(this.callbacksPerIndex.lastKey()) : (requested.length == 1 ? new PriorEventBufferSingle(requested[0]) : new PriorEventBufferMulti(requested));
        int relativeIndex = 0;
        for (int reqIndex : this.callbacksPerIndex.keySet()) {
            List<ViewResourceCallback> callbacks = this.callbacksPerIndex.get(reqIndex);
            for (ViewResourceCallback callback : callbacks) {
                if (viewUpdatedCollection instanceof RelativeAccessByEventNIndex) {
                    RelativeAccessByEventNIndex relativeAccess = (RelativeAccessByEventNIndex)((Object)viewUpdatedCollection);
                    callback.setViewResource(new RelativeAccessImpl(relativeAccess, relativeIndex));
                    continue;
                }
                callback.setViewResource(viewUpdatedCollection);
            }
            ++relativeIndex;
        }
        return new PriorEventView(viewUpdatedCollection);
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public boolean canReuse(View view) {
        return false;
    }

    public static class RelativeAccessImpl
    implements RelativeAccessByEventNIndex {
        private final RelativeAccessByEventNIndex buffer;
        private final int relativeIndex;

        public RelativeAccessImpl(RelativeAccessByEventNIndex buffer, int relativeIndex) {
            this.buffer = buffer;
            this.relativeIndex = relativeIndex;
        }

        public EventBean getRelativeToEvent(EventBean event, int prevIndex) {
            return this.buffer.getRelativeToEvent(event, this.relativeIndex);
        }
    }
}

