/*
 * Decompiled with CFR 0.152.
 */
package net.esper.view.stat;

import java.util.Iterator;
import net.esper.collection.SingleEventIterator;
import net.esper.core.StatementContext;
import net.esper.event.EventBean;
import net.esper.event.EventPropertyGetter;
import net.esper.view.ViewSupport;
import net.esper.view.Viewable;
import net.esper.view.stat.BaseStatisticsBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseBivariateStatisticsView
extends ViewSupport {
    protected BaseStatisticsBean statisticsBean;
    private String fieldNameX;
    private String fieldNameY;
    private EventPropertyGetter fieldXGetter;
    private EventPropertyGetter fieldYGetter;
    protected StatementContext statementContext;
    private EventBean lastNewEvent;

    public BaseBivariateStatisticsView(StatementContext statementContext, BaseStatisticsBean statisticsBean, String fieldNameX, String fieldNameY) {
        this.statementContext = statementContext;
        this.statisticsBean = statisticsBean;
        this.fieldNameX = fieldNameX;
        this.fieldNameY = fieldNameY;
    }

    @Override
    public final void setParent(Viewable parent) {
        super.setParent(parent);
        if (parent != null) {
            this.fieldXGetter = parent.getEventType().getGetter(this.fieldNameX);
            this.fieldYGetter = parent.getEventType().getGetter(this.fieldNameY);
        }
    }

    @Override
    public void update(EventBean[] newData, EventBean[] oldData) {
        double Y;
        double X;
        int i;
        BaseStatisticsBean oldValues = null;
        if (this.lastNewEvent == null && this.hasViews()) {
            oldValues = (BaseStatisticsBean)this.statisticsBean.clone();
        }
        if (newData != null) {
            for (i = 0; i < newData.length; ++i) {
                X = ((Number)this.fieldXGetter.get(newData[i])).doubleValue();
                Y = ((Number)this.fieldYGetter.get(newData[i])).doubleValue();
                this.statisticsBean.addPoint(X, Y);
            }
        }
        if (oldData != null) {
            for (i = 0; i < oldData.length; ++i) {
                X = ((Number)this.fieldXGetter.get(oldData[i])).doubleValue();
                Y = ((Number)this.fieldYGetter.get(oldData[i])).doubleValue();
                this.statisticsBean.removePoint(X, Y);
            }
        }
        if (this.hasViews()) {
            if (this.lastNewEvent == null) {
                BaseStatisticsBean newValues = (BaseStatisticsBean)this.statisticsBean.clone();
                EventBean newValuesEvent = this.statementContext.getEventAdapterService().adapterForBean(newValues);
                EventBean oldValuesEvent = this.statementContext.getEventAdapterService().adapterForBean(oldValues);
                this.updateChildren(new EventBean[]{newValuesEvent}, new EventBean[]{oldValuesEvent});
                this.lastNewEvent = newValuesEvent;
            } else {
                BaseStatisticsBean newValues = (BaseStatisticsBean)this.statisticsBean.clone();
                EventBean newValuesEvent = this.statementContext.getEventAdapterService().adapterForBean(newValues);
                this.updateChildren(new EventBean[]{newValuesEvent}, new EventBean[]{this.lastNewEvent});
                this.lastNewEvent = newValuesEvent;
            }
        }
    }

    @Override
    public final Iterator<EventBean> iterator() {
        return new SingleEventIterator(this.statementContext.getEventAdapterService().adapterForBean(this.statisticsBean));
    }

    public final String getFieldNameX() {
        return this.fieldNameX;
    }

    public final String getFieldNameY() {
        return this.fieldNameY;
    }
}

