/*
 * Decompiled with CFR 0.152.
 */
package net.esper.view.stat;

import java.util.HashMap;
import java.util.Iterator;
import net.esper.collection.MultiKeyUntyped;
import net.esper.collection.SingleEventIterator;
import net.esper.core.StatementContext;
import net.esper.event.EventBean;
import net.esper.event.EventPropertyGetter;
import net.esper.event.EventType;
import net.esper.util.ExecutionPathDebugLog;
import net.esper.view.CloneableView;
import net.esper.view.View;
import net.esper.view.ViewFieldEnum;
import net.esper.view.ViewSupport;
import net.esper.view.Viewable;
import net.esper.view.stat.BaseStatisticsBean;
import net.esper.view.stat.olap.Cube;
import net.esper.view.stat.olap.CubeImpl;
import net.esper.view.stat.olap.MultidimCube;
import net.esper.view.stat.olap.MultidimCubeCellFactory;
import net.esper.view.stat.olap.MultidimCubeImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MultiDimStatsView
extends ViewSupport
implements CloneableView {
    private EventType eventType;
    private static final MultidimCubeCellFactory<BaseStatisticsBean> multidimCubeCellFactory = new MultidimCubeCellFactory<BaseStatisticsBean>(){

        @Override
        public BaseStatisticsBean newCell() {
            return new BaseStatisticsBean();
        }

        public BaseStatisticsBean[] newCells(int numElements) {
            return new BaseStatisticsBean[numElements];
        }
    };
    private final StatementContext statementContext;
    private final String[] derivedMeasures;
    private final String measureField;
    private final String columnField;
    private final String rowField;
    private final String pageField;
    private EventPropertyGetter measureFieldGetter;
    private EventPropertyGetter columnFieldGetter;
    private EventPropertyGetter rowFieldGetter;
    private EventPropertyGetter pageFieldGetter;
    private MultidimCube<BaseStatisticsBean> multidimCube;
    private static final Log log = LogFactory.getLog(MultiDimStatsView.class);

    public MultiDimStatsView(StatementContext statementContext, String[] derivedMeasures, String measureField, String columnField, String rowField, String pageField) {
        this.statementContext = statementContext;
        this.derivedMeasures = derivedMeasures;
        this.measureField = measureField;
        this.columnField = columnField;
        this.rowField = rowField;
        this.pageField = pageField;
        this.eventType = MultiDimStatsView.createEventType(statementContext);
    }

    @Override
    public View cloneView(StatementContext statementContext) {
        return new MultiDimStatsView(statementContext, this.derivedMeasures, this.measureField, this.columnField, this.rowField, this.pageField);
    }

    public final String[] getDerivedMeasures() {
        return this.derivedMeasures;
    }

    public final String getMeasureField() {
        return this.measureField;
    }

    public final String getColumnField() {
        return this.columnField;
    }

    public final String getRowField() {
        return this.rowField;
    }

    public final String getPageField() {
        return this.pageField;
    }

    protected final MultidimCube<BaseStatisticsBean> getFactCube() {
        return this.multidimCube;
    }

    @Override
    public final void setParent(Viewable parent) {
        super.setParent(parent);
        if (parent == null) {
            return;
        }
        this.measureFieldGetter = parent.getEventType().getGetter(this.measureField);
        this.columnFieldGetter = parent.getEventType().getGetter(this.columnField);
        if (this.rowField != null) {
            this.rowFieldGetter = parent.getEventType().getGetter(this.rowField);
        }
        if (this.pageField != null) {
            this.pageFieldGetter = parent.getEventType().getGetter(this.pageField);
        }
        if (this.pageField != null) {
            String[] dimensionNames = new String[]{this.measureField, this.columnField, this.rowField, this.pageField};
            this.multidimCube = new MultidimCubeImpl<BaseStatisticsBean>(dimensionNames, multidimCubeCellFactory);
            this.multidimCube.setMembers(2, parent.getEventType().getPropertyType(this.pageField));
            this.multidimCube.setMembers(1, parent.getEventType().getPropertyType(this.rowField));
        } else if (this.rowField != null) {
            String[] dimensionNames = new String[]{this.measureField, this.columnField, this.rowField};
            this.multidimCube = new MultidimCubeImpl<BaseStatisticsBean>(dimensionNames, multidimCubeCellFactory);
            this.multidimCube.setMembers(1, parent.getEventType().getPropertyType(this.rowField));
        } else {
            String[] dimensionNames = new String[]{this.measureField, this.columnField};
            this.multidimCube = new MultidimCubeImpl<BaseStatisticsBean>(dimensionNames, multidimCubeCellFactory);
        }
        this.multidimCube.setMembers(0, parent.getEventType().getPropertyType(this.columnField));
    }

    @Override
    public final void update(EventBean[] newData, EventBean[] oldData) {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".update Received update,   newData.length==" + (newData == null ? 0 : newData.length) + "  oldData.length==" + (oldData == null ? 0 : oldData.length));
        }
        if (newData != null) {
            for (EventBean newValue : newData) {
                this.processElement(newValue, true);
            }
        }
        if (oldData != null) {
            for (EventBean oldValue : oldData) {
                this.processElement(oldValue, false);
            }
        }
        if (this.hasViews()) {
            EventBean postNewData = this.populateEvent();
            this.updateChildren(new EventBean[]{postNewData}, null);
        }
    }

    @Override
    public final EventType getEventType() {
        return this.eventType;
    }

    @Override
    public final Iterator<EventBean> iterator() {
        return new SingleEventIterator(this.populateEvent());
    }

    private void processElement(EventBean element, boolean isNewData) {
        Object rowMember;
        MultiKeyUntyped coordinates = null;
        Object columnMember = this.columnFieldGetter.get(element);
        if (this.pageFieldGetter != null) {
            rowMember = this.rowFieldGetter.get(element);
            Object pageMember = this.pageFieldGetter.get(element);
            coordinates = new MultiKeyUntyped(columnMember, rowMember, pageMember);
        } else if (this.rowFieldGetter != null) {
            rowMember = this.rowFieldGetter.get(element);
            coordinates = new MultiKeyUntyped(columnMember, rowMember);
        } else {
            coordinates = new MultiKeyUntyped(columnMember);
        }
        double measureValue = ((Number)this.measureFieldGetter.get(element)).doubleValue();
        BaseStatisticsBean cell = this.multidimCube.getCellAddMembers(coordinates);
        if (isNewData) {
            cell.addPoint(measureValue);
        } else {
            cell.removePoint(measureValue);
        }
    }

    private EventBean populateEvent() {
        CubeImpl cube = new CubeImpl(this.multidimCube, this.derivedMeasures);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put(ViewFieldEnum.MULTIDIM_OLAP__CUBE.getName(), cube);
        return this.statementContext.getEventAdapterService().createMapFromValues(result, this.eventType);
    }

    protected static EventType createEventType(StatementContext statementContext) {
        HashMap<String, Class> schemaMap = new HashMap<String, Class>();
        schemaMap.put(ViewFieldEnum.MULTIDIM_OLAP__CUBE.getName(), Cube.class);
        return statementContext.getEventAdapterService().createAnonymousMapType(schemaMap);
    }
}

