/*
 * Decompiled with CFR 0.152.
 */
package net.esper.view.stat;

import java.util.Arrays;
import java.util.List;
import net.esper.core.StatementContext;
import net.esper.eql.core.ViewResourceCallback;
import net.esper.event.EventType;
import net.esper.view.PropertyCheckHelper;
import net.esper.view.View;
import net.esper.view.ViewAttachException;
import net.esper.view.ViewCapability;
import net.esper.view.ViewFactory;
import net.esper.view.ViewFactoryContext;
import net.esper.view.ViewFieldEnum;
import net.esper.view.ViewParameterException;
import net.esper.view.stat.MultiDimStatsView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiDimStatsViewFactory
implements ViewFactory {
    protected String[] derivedMeasures;
    protected String measureField;
    protected String columnField;
    protected String rowField;
    protected String pageField;
    private EventType eventType;

    @Override
    public void setViewParameters(ViewFactoryContext viewFactoryContext, List<Object> viewParameters) throws ViewParameterException {
        String errorMessage = "'Multi-dimensional stats' view requires a String-array and 2 or more field names as parameters";
        if (viewParameters.size() < 3) {
            throw new ViewParameterException(errorMessage);
        }
        if (!(viewParameters.get(0) instanceof String[] && viewParameters.get(1) instanceof String && viewParameters.get(2) instanceof String)) {
            throw new ViewParameterException(errorMessage);
        }
        this.derivedMeasures = (String[])viewParameters.get(0);
        this.measureField = (String)viewParameters.get(1);
        this.columnField = (String)viewParameters.get(2);
        if (viewParameters.size() > 3) {
            if (!(viewParameters.get(3) instanceof String)) {
                throw new ViewParameterException(errorMessage);
            }
            this.rowField = (String)viewParameters.get(3);
        }
        if (viewParameters.size() > 4) {
            if (!(viewParameters.get(4) instanceof String)) {
                throw new ViewParameterException(errorMessage);
            }
            this.pageField = (String)viewParameters.get(4);
        }
        for (String measureName : this.derivedMeasures) {
            if (Arrays.binarySearch(ViewFieldEnum.MULTIDIM_OLAP__MEASURES, measureName) >= 0) continue;
            throw new ViewParameterException("Derived measure named '" + measureName + "' is not a valid measure");
        }
    }

    @Override
    public void attach(EventType parentEventType, StatementContext statementContext, ViewFactory optionalParentFactory, List<ViewFactory> parentViewFactories) throws ViewAttachException {
        String message = PropertyCheckHelper.checkNumeric(parentEventType, this.measureField);
        if (message != null) {
            throw new ViewAttachException(message);
        }
        message = PropertyCheckHelper.exists(parentEventType, this.columnField);
        if (message != null) {
            throw new ViewAttachException(message);
        }
        if (this.rowField != null && (message = PropertyCheckHelper.exists(parentEventType, this.rowField)) != null) {
            throw new ViewAttachException(message);
        }
        if (this.pageField != null && (message = PropertyCheckHelper.exists(parentEventType, this.pageField)) != null) {
            throw new ViewAttachException(message);
        }
        this.eventType = MultiDimStatsView.createEventType(statementContext);
    }

    @Override
    public boolean canProvideCapability(ViewCapability viewCapability) {
        return false;
    }

    @Override
    public void setProvideCapability(ViewCapability viewCapability, ViewResourceCallback resourceCallback) {
        throw new UnsupportedOperationException("View capability " + viewCapability.getClass().getSimpleName() + " not supported");
    }

    @Override
    public View makeView(StatementContext statementContext) {
        return new MultiDimStatsView(statementContext, this.derivedMeasures, this.measureField, this.columnField, this.rowField, this.pageField);
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public boolean canReuse(View view) {
        if (!(view instanceof MultiDimStatsView)) {
            return false;
        }
        MultiDimStatsView other = (MultiDimStatsView)view;
        if (!Arrays.deepEquals(other.getDerivedMeasures(), this.derivedMeasures)) {
            return false;
        }
        if (!other.getMeasureField().equals(this.measureField)) {
            return false;
        }
        if (!other.getColumnField().equals(this.columnField)) {
            return false;
        }
        if (other.getRowField() != null && this.rowField != null && !other.getRowField().equals(this.rowField)) {
            return false;
        }
        if (other.getRowField() == null && this.rowField != null || other.getRowField() != null && this.rowField == null) {
            return false;
        }
        if (other.getPageField() != null && this.pageField != null && !other.getPageField().equals(this.pageField)) {
            return false;
        }
        return (other.getPageField() != null || this.pageField == null) && (other.getPageField() == null || this.pageField != null);
    }
}

