/*
 * Decompiled with CFR 0.152.
 */
package net.esper.view.stat;

import java.util.HashMap;
import java.util.Iterator;
import net.esper.collection.SingleEventIterator;
import net.esper.core.StatementContext;
import net.esper.event.EventAdapterService;
import net.esper.event.EventBean;
import net.esper.event.EventPropertyGetter;
import net.esper.event.EventType;
import net.esper.view.CloneableView;
import net.esper.view.View;
import net.esper.view.ViewFieldEnum;
import net.esper.view.ViewSupport;
import net.esper.view.Viewable;
import net.esper.view.stat.BaseStatisticsBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UnivariateStatisticsView
extends ViewSupport
implements CloneableView {
    private final StatementContext statementContext;
    private final EventType eventType;
    private final String fieldName;
    private EventPropertyGetter fieldGetter;
    private final BaseStatisticsBean baseStatisticsBean = new BaseStatisticsBean();
    private EventBean lastNewEvent;

    public UnivariateStatisticsView(StatementContext statementContext, String fieldName) {
        this.statementContext = statementContext;
        this.fieldName = fieldName;
        this.eventType = UnivariateStatisticsView.createEventType(statementContext);
    }

    @Override
    public View cloneView(StatementContext statementContext) {
        return new UnivariateStatisticsView(statementContext, this.fieldName);
    }

    @Override
    public void setParent(Viewable parent) {
        super.setParent(parent);
        if (parent != null) {
            this.fieldGetter = parent.getEventType().getGetter(this.fieldName);
        }
    }

    public final String getFieldName() {
        return this.fieldName;
    }

    @Override
    public final void update(EventBean[] newData, EventBean[] oldData) {
        double point;
        int i;
        EventBean oldDataMap = null;
        if (this.lastNewEvent == null && this.hasViews()) {
            oldDataMap = UnivariateStatisticsView.populateMap(this.baseStatisticsBean, this.statementContext.getEventAdapterService(), this.eventType);
        }
        if (newData != null) {
            for (i = 0; i < newData.length; ++i) {
                point = ((Number)this.fieldGetter.get(newData[i])).doubleValue();
                this.baseStatisticsBean.addPoint(point, 0.0);
            }
        }
        if (oldData != null) {
            for (i = 0; i < oldData.length; ++i) {
                point = ((Number)this.fieldGetter.get(oldData[i])).doubleValue();
                this.baseStatisticsBean.removePoint(point, 0.0);
            }
        }
        if (this.hasViews()) {
            EventBean newDataMap = UnivariateStatisticsView.populateMap(this.baseStatisticsBean, this.statementContext.getEventAdapterService(), this.eventType);
            if (this.lastNewEvent == null) {
                this.updateChildren(new EventBean[]{newDataMap}, new EventBean[]{oldDataMap});
            } else {
                this.updateChildren(new EventBean[]{newDataMap}, new EventBean[]{this.lastNewEvent});
            }
            this.lastNewEvent = newDataMap;
        }
    }

    @Override
    public final EventType getEventType() {
        return this.eventType;
    }

    @Override
    public final Iterator<EventBean> iterator() {
        return new SingleEventIterator(UnivariateStatisticsView.populateMap(this.baseStatisticsBean, this.statementContext.getEventAdapterService(), this.eventType));
    }

    public final String toString() {
        return this.getClass().getName() + " fieldName=" + this.fieldName;
    }

    private static EventBean populateMap(BaseStatisticsBean baseStatisticsBean, EventAdapterService eventAdapterService, EventType eventType) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put(ViewFieldEnum.UNIVARIATE_STATISTICS__COUNT.getName(), baseStatisticsBean.getN());
        result.put(ViewFieldEnum.UNIVARIATE_STATISTICS__SUM.getName(), baseStatisticsBean.getXSum());
        result.put(ViewFieldEnum.UNIVARIATE_STATISTICS__STDDEV.getName(), baseStatisticsBean.getXStandardDeviationSample());
        result.put(ViewFieldEnum.UNIVARIATE_STATISTICS__STDDEVPA.getName(), baseStatisticsBean.getXStandardDeviationPop());
        result.put(ViewFieldEnum.UNIVARIATE_STATISTICS__VARIANCE.getName(), baseStatisticsBean.getXVariance());
        result.put(ViewFieldEnum.UNIVARIATE_STATISTICS__AVERAGE.getName(), baseStatisticsBean.getXAverage());
        return eventAdapterService.createMapFromValues(result, eventType);
    }

    protected static EventType createEventType(StatementContext statementContext) {
        HashMap<String, Class> eventTypeMap = new HashMap<String, Class>();
        eventTypeMap.put(ViewFieldEnum.UNIVARIATE_STATISTICS__COUNT.getName(), Long.TYPE);
        eventTypeMap.put(ViewFieldEnum.UNIVARIATE_STATISTICS__SUM.getName(), Double.TYPE);
        eventTypeMap.put(ViewFieldEnum.UNIVARIATE_STATISTICS__STDDEV.getName(), Double.TYPE);
        eventTypeMap.put(ViewFieldEnum.UNIVARIATE_STATISTICS__STDDEVPA.getName(), Double.TYPE);
        eventTypeMap.put(ViewFieldEnum.UNIVARIATE_STATISTICS__VARIANCE.getName(), Double.TYPE);
        eventTypeMap.put(ViewFieldEnum.UNIVARIATE_STATISTICS__AVERAGE.getName(), Double.TYPE);
        return statementContext.getEventAdapterService().createAnonymousMapType(eventTypeMap);
    }
}

