/*
 * Decompiled with CFR 0.152.
 */
package net.esper.view.stat;

import java.util.List;
import net.esper.core.StatementContext;
import net.esper.eql.core.ViewResourceCallback;
import net.esper.event.EventType;
import net.esper.view.PropertyCheckHelper;
import net.esper.view.View;
import net.esper.view.ViewAttachException;
import net.esper.view.ViewCapability;
import net.esper.view.ViewFactory;
import net.esper.view.ViewFactoryContext;
import net.esper.view.ViewParameterException;
import net.esper.view.stat.UnivariateStatisticsView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnivariateStatisticsViewFactory
implements ViewFactory {
    protected String fieldName;
    private EventType eventType;

    @Override
    public void setViewParameters(ViewFactoryContext viewFactoryContext, List<Object> viewParameters) throws ViewParameterException {
        String errorMessage = "'Univariate statistics' view require a single field name as a parameter";
        if (viewParameters.size() != 1) {
            throw new ViewParameterException(errorMessage);
        }
        if (!(viewParameters.get(0) instanceof String)) {
            throw new ViewParameterException(errorMessage);
        }
        this.fieldName = (String)viewParameters.get(0);
    }

    @Override
    public void attach(EventType parentEventType, StatementContext statementContext, ViewFactory optionalParentFactory, List<ViewFactory> parentViewFactories) throws ViewAttachException {
        String result = PropertyCheckHelper.checkNumeric(parentEventType, this.fieldName);
        if (result != null) {
            throw new ViewAttachException(result);
        }
        this.eventType = UnivariateStatisticsView.createEventType(statementContext);
    }

    @Override
    public boolean canProvideCapability(ViewCapability viewCapability) {
        return false;
    }

    @Override
    public void setProvideCapability(ViewCapability viewCapability, ViewResourceCallback resourceCallback) {
        throw new UnsupportedOperationException("View capability " + viewCapability.getClass().getSimpleName() + " not supported");
    }

    @Override
    public View makeView(StatementContext statementContext) {
        return new UnivariateStatisticsView(statementContext, this.fieldName);
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public boolean canReuse(View view) {
        if (!(view instanceof UnivariateStatisticsView)) {
            return false;
        }
        UnivariateStatisticsView other = (UnivariateStatisticsView)view;
        return other.getFieldName().equals(this.fieldName);
    }
}

