/*
 * Decompiled with CFR 0.152.
 */
package net.esper.view.stat;

import java.util.HashMap;
import java.util.Iterator;
import net.esper.collection.SingleEventIterator;
import net.esper.core.StatementContext;
import net.esper.event.EventBean;
import net.esper.event.EventPropertyGetter;
import net.esper.event.EventType;
import net.esper.view.CloneableView;
import net.esper.view.View;
import net.esper.view.ViewFieldEnum;
import net.esper.view.ViewSupport;
import net.esper.view.Viewable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WeightedAverageView
extends ViewSupport
implements CloneableView {
    private final EventType eventType;
    private final StatementContext statementContext;
    private final String fieldNameX;
    private final String fieldNameWeight;
    private EventPropertyGetter fieldXGetter;
    private EventPropertyGetter fieldWeightGetter;
    private double sumXtimesW = Double.NaN;
    private double sumW = Double.NaN;
    private double currentValue = Double.NaN;
    private EventBean lastNewEvent;

    public WeightedAverageView(StatementContext statementContext, String fieldNameX, String fieldNameWeight) {
        this.fieldNameX = fieldNameX;
        this.fieldNameWeight = fieldNameWeight;
        this.statementContext = statementContext;
        this.eventType = WeightedAverageView.createEventType(statementContext);
    }

    @Override
    public View cloneView(StatementContext statementContext) {
        return new WeightedAverageView(statementContext, this.fieldNameX, this.fieldNameWeight);
    }

    @Override
    public void setParent(Viewable parent) {
        super.setParent(parent);
        if (parent != null) {
            this.fieldXGetter = parent.getEventType().getGetter(this.fieldNameX);
            this.fieldWeightGetter = parent.getEventType().getGetter(this.fieldNameWeight);
        }
    }

    public final String getFieldNameX() {
        return this.fieldNameX;
    }

    public final String getFieldNameWeight() {
        return this.fieldNameWeight;
    }

    @Override
    public final void update(EventBean[] newData, EventBean[] oldData) {
        double weight;
        double point;
        int i;
        double oldValue = this.currentValue;
        if (newData != null) {
            for (i = 0; i < newData.length; ++i) {
                point = ((Number)this.fieldXGetter.get(newData[i])).doubleValue();
                weight = ((Number)this.fieldWeightGetter.get(newData[i])).doubleValue();
                if (Double.valueOf(this.sumXtimesW).isNaN()) {
                    this.sumXtimesW = point * weight;
                    this.sumW = weight;
                    continue;
                }
                this.sumXtimesW += point * weight;
                this.sumW += weight;
            }
        }
        if (oldData != null) {
            for (i = 0; i < oldData.length; ++i) {
                point = ((Number)this.fieldXGetter.get(oldData[i])).doubleValue();
                weight = ((Number)this.fieldWeightGetter.get(oldData[i])).doubleValue();
                this.sumXtimesW -= point * weight;
                this.sumW -= weight;
            }
        }
        this.currentValue = this.sumW != 0.0 ? this.sumXtimesW / this.sumW : Double.NaN;
        if (this.hasViews()) {
            HashMap<String, Object> newDataMap = new HashMap<String, Object>();
            newDataMap.put(ViewFieldEnum.WEIGHTED_AVERAGE__AVERAGE.getName(), this.currentValue);
            EventBean newDataEvent = this.statementContext.getEventAdapterService().createMapFromValues(newDataMap, this.eventType);
            if (this.lastNewEvent == null) {
                HashMap<String, Object> oldDataMap = new HashMap<String, Object>();
                oldDataMap.put(ViewFieldEnum.WEIGHTED_AVERAGE__AVERAGE.getName(), oldValue);
                EventBean oldDataEvent = this.statementContext.getEventAdapterService().createMapFromValues(oldDataMap, this.eventType);
                this.updateChildren(new EventBean[]{newDataEvent}, new EventBean[]{oldDataEvent});
            } else {
                this.updateChildren(new EventBean[]{newDataEvent}, new EventBean[]{this.lastNewEvent});
                this.lastNewEvent = newDataEvent;
            }
        }
    }

    @Override
    public final EventType getEventType() {
        return this.eventType;
    }

    @Override
    public final Iterator<EventBean> iterator() {
        HashMap<String, Object> newDataMap = new HashMap<String, Object>();
        newDataMap.put(ViewFieldEnum.WEIGHTED_AVERAGE__AVERAGE.getName(), this.currentValue);
        return new SingleEventIterator(this.statementContext.getEventAdapterService().createMapFromValues(newDataMap, this.eventType));
    }

    public final String toString() {
        return this.getClass().getName() + " fieldName=" + this.fieldNameX + " fieldNameWeight=" + this.fieldNameWeight;
    }

    protected static EventType createEventType(StatementContext statementContext) {
        HashMap<String, Class> schemaMap = new HashMap<String, Class>();
        schemaMap.put(ViewFieldEnum.WEIGHTED_AVERAGE__AVERAGE.getName(), Double.TYPE);
        return statementContext.getEventAdapterService().createAnonymousMapType(schemaMap);
    }
}

