/*
 * Decompiled with CFR 0.152.
 */
package net.esper.view.stat.olap;

import java.util.List;
import net.esper.collection.Pair;
import net.esper.view.ViewFieldEnum;
import net.esper.view.stat.BaseStatisticsBean;
import net.esper.view.stat.olap.Cell;
import net.esper.view.stat.olap.CellImpl;
import net.esper.view.stat.olap.Dimension;
import net.esper.view.stat.olap.DimensionImpl;
import net.esper.view.stat.olap.DimensionMember;
import net.esper.view.stat.olap.DimensionMemberImpl;
import net.esper.view.stat.olap.MultidimCube;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CubeDerivedValueHelper {
    public static Pair<Dimension[], Cell[]> derive(String[] measuresToDerive, MultidimCube<BaseStatisticsBean> cube) {
        DimensionImpl cellDimension;
        int numDimensions = cube.getNumDimensions();
        String[] dimPropertyNames = cube.getDimensionNames();
        DimensionImpl[] dimensions = new DimensionImpl[numDimensions + 1];
        dimensions[0] = cellDimension = new DimensionImpl(new String[]{"derived"});
        DimensionMember[] cellMembers = new DimensionMemberImpl[measuresToDerive.length];
        for (int derivedIndex = 0; derivedIndex < measuresToDerive.length; ++derivedIndex) {
            DimensionMemberImpl newMember = new DimensionMemberImpl(new Object[]{measuresToDerive[derivedIndex]});
            cellMembers[derivedIndex] = newMember;
            newMember.setDimension(cellDimension);
        }
        cellDimension.setMembers(cellMembers);
        for (int i = 0; i < numDimensions; ++i) {
            String[] propertyNames = new String[]{dimPropertyNames[i]};
            DimensionImpl newDimension = new DimensionImpl(propertyNames);
            DimensionMember[] members = CubeDerivedValueHelper.makeMembers(newDimension, cube.getMembers(i));
            dimensions[i + 1] = newDimension;
            newDimension.setMembers(members);
        }
        BaseStatisticsBean[] facts = cube.getCells();
        Cell[] measures = new Cell[facts.length * measuresToDerive.length];
        int measureOrdinal = 0;
        for (int factIndex = 0; factIndex < facts.length; ++factIndex) {
            for (int derivedIndex = 0; derivedIndex < measuresToDerive.length; ++derivedIndex) {
                double measureValue = CubeDerivedValueHelper.getMeasure(measuresToDerive[derivedIndex], facts[factIndex]);
                measures[measureOrdinal] = new CellImpl(measureValue);
                ++measureOrdinal;
            }
        }
        return new Pair<DimensionImpl[], Cell[]>(dimensions, measures);
    }

    private static DimensionMember[] makeMembers(DimensionImpl dimension, List<Object> memberList) {
        DimensionMember[] members = new DimensionMember[memberList.size()];
        int index = 0;
        for (Object object : memberList) {
            DimensionMemberImpl newMember = new DimensionMemberImpl(new Object[]{object});
            newMember.setDimension(dimension);
            members[index] = newMember;
            ++index;
        }
        return members;
    }

    private static double getMeasure(String measureName, BaseStatisticsBean statBean) {
        if (measureName.equals(ViewFieldEnum.UNIVARIATE_STATISTICS__AVERAGE.getName())) {
            return statBean.getXAverage();
        }
        if (measureName.equals(ViewFieldEnum.UNIVARIATE_STATISTICS__COUNT.getName())) {
            return statBean.getN();
        }
        if (measureName.equals(ViewFieldEnum.UNIVARIATE_STATISTICS__STDDEV.getName())) {
            return statBean.getXStandardDeviationSample();
        }
        if (measureName.equals(ViewFieldEnum.UNIVARIATE_STATISTICS__STDDEVPA.getName())) {
            return statBean.getXStandardDeviationPop();
        }
        if (measureName.equals(ViewFieldEnum.UNIVARIATE_STATISTICS__SUM.getName())) {
            return statBean.getXSum();
        }
        if (measureName.equals(ViewFieldEnum.UNIVARIATE_STATISTICS__VARIANCE.getName())) {
            return statBean.getXVariance();
        }
        throw new IllegalArgumentException("Cell named " + measureName + " not known");
    }
}

