/*
 * Decompiled with CFR 0.152.
 */
package net.esper.view.stat.olap;

import java.util.NoSuchElementException;
import net.esper.view.stat.olap.Dimension;

public final class CubeDimensionHelper {
    protected static int getTotalCells(int[] dimensionSizes) {
        int product = 1;
        for (int i = 0; i < dimensionSizes.length; ++i) {
            if (dimensionSizes[i] == 0) continue;
            product *= dimensionSizes[i];
        }
        return product;
    }

    protected static void nextIndize(int[] dimensionSizes, int[] dimensionIndizes) {
        block1: {
            int dimension = 0;
            do {
                int n = dimension;
                dimensionIndizes[n] = dimensionIndizes[n] + 1;
                if (dimensionIndizes[dimension] < dimensionSizes[dimension]) break block1;
                dimensionIndizes[dimension] = 0;
            } while (++dimension < dimensionSizes.length);
            throw new NoSuchElementException("Attempt to position past indize range");
        }
    }

    protected static int[] getDimensionSizes(Dimension[] dimensions) {
        int[] dimensionSizes = new int[dimensions.length];
        for (int i = 0; i < dimensions.length; ++i) {
            dimensionSizes[i] = dimensions[i].getMembers().length;
        }
        return dimensionSizes;
    }

    protected static int getOrdinal(int[] dimensionIndizes, int[] dimensionSizes) {
        int ordinal = dimensionIndizes[0];
        int offset = 1;
        for (int i = 1; i < dimensionIndizes.length; ++i) {
            ordinal += dimensionIndizes[i] * (offset *= dimensionSizes[i - 1]);
        }
        return ordinal;
    }
}

