/*
 * Decompiled with CFR 0.152.
 */
package net.esper.view.stat.olap;

import java.util.HashMap;
import java.util.Map;
import net.esper.collection.Pair;
import net.esper.util.MetaDefItem;
import net.esper.view.stat.BaseStatisticsBean;
import net.esper.view.stat.olap.Cell;
import net.esper.view.stat.olap.Cube;
import net.esper.view.stat.olap.CubeDerivedValueHelper;
import net.esper.view.stat.olap.CubeDimensionHelper;
import net.esper.view.stat.olap.Dimension;
import net.esper.view.stat.olap.DimensionMember;
import net.esper.view.stat.olap.MultidimCube;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CubeImpl
implements Cube,
MetaDefItem {
    private final MultidimCube<BaseStatisticsBean> cube;
    private final String[] measuresToDerive;
    private Dimension[] dimensions;
    private Cell[] measures;
    private Map<Integer, DimensionMember[]> intersections;

    public CubeImpl(MultidimCube<BaseStatisticsBean> cube, String[] measuresToDerive) {
        this.cube = cube;
        this.measuresToDerive = measuresToDerive;
    }

    @Override
    public final Dimension[] getDimensions() {
        if (this.dimensions == null) {
            this.derive();
        }
        return this.dimensions;
    }

    @Override
    public final Cell[] getMeasures() {
        if (this.measures == null) {
            this.derive();
        }
        return this.measures;
    }

    @Override
    public final DimensionMember[] getMembers(int ordinal) {
        if (ordinal < 0 || this.measures != null && ordinal >= this.measures.length) {
            throw new IllegalArgumentException("Invalid ordinal value");
        }
        if (this.measures == null) {
            this.derive();
        }
        if (this.intersections == null) {
            this.determineIntersections();
        }
        return this.intersections.get(ordinal);
    }

    @Override
    public final int getOrdinal(DimensionMember[] members) {
        if (this.measures == null) {
            this.derive();
        }
        if (members == null) {
            throw new IllegalArgumentException("DimensionMember array reference is null");
        }
        if (members.length != this.dimensions.length) {
            throw new IllegalArgumentException("Size of member array does not match number of cube dimensions");
        }
        int[] dimensionIndizes = new int[this.dimensions.length];
        for (int dimension = 0; dimension < dimensionIndizes.length; ++dimension) {
            int memberIndex = CubeImpl.findMember(this.dimensions[dimension].getMembers(), members[dimension]);
            if (memberIndex < 0) {
                return -1;
            }
            dimensionIndizes[dimension] = memberIndex;
        }
        return CubeDimensionHelper.getOrdinal(dimensionIndizes, CubeDimensionHelper.getDimensionSizes(this.dimensions));
    }

    private void derive() {
        Pair<Dimension[], Cell[]> derivedCube = CubeDerivedValueHelper.derive(this.measuresToDerive, this.cube);
        this.dimensions = derivedCube.getFirst();
        this.measures = derivedCube.getSecond();
    }

    private void determineIntersections() {
        this.intersections = new HashMap<Integer, DimensionMember[]>();
        int[] dimensionIndizes = new int[this.dimensions.length];
        int[] dimensionSizes = CubeDimensionHelper.getDimensionSizes(this.dimensions);
        for (int ordinal = 0; ordinal < this.measures.length; ++ordinal) {
            DimensionMember[] members = new DimensionMember[this.dimensions.length];
            for (int dimension = 0; dimension < members.length; ++dimension) {
                int memberIndex = dimensionIndizes[dimension];
                members[dimension] = this.dimensions[dimension].getMembers()[memberIndex];
            }
            if (ordinal + 1 < this.measures.length) {
                CubeDimensionHelper.nextIndize(dimensionSizes, dimensionIndizes);
            }
            this.intersections.put(ordinal, members);
        }
    }

    private static int findMember(DimensionMember[] members, DimensionMember dimensionMember) {
        for (int i = 0; i < members.length; ++i) {
            if (members[i] != dimensionMember) continue;
            return i;
        }
        return -1;
    }
}

