/*
 * Decompiled with CFR 0.152.
 */
package net.esper.view.stat.olap;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.esper.collection.MultiKeyUntyped;
import net.esper.util.MetaDefItem;
import net.esper.view.stat.olap.CubeDimensionHelper;
import net.esper.view.stat.olap.MultidimCube;
import net.esper.view.stat.olap.MultidimCubeCellFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MultidimCubeImpl<V>
implements MultidimCube<V>,
MetaDefItem {
    private final int numDimensions;
    private V[] cells;
    private final MultidimCubeCellFactory<V> multidimCubeCellFactory;
    private final Map<MultiKeyUntyped, Integer> ordinals = new HashMap<MultiKeyUntyped, Integer>();
    private final Map<Integer, List<Object>> dimensionMembers = new HashMap<Integer, List<Object>>();
    private final String[] dimensionNames;

    public MultidimCubeImpl(String[] dimensionNames, MultidimCubeCellFactory<V> multidimCubeCellFactory) {
        if (dimensionNames.length < 2) {
            throw new IllegalArgumentException("Cannot create a cube with less then 1 dimensions");
        }
        this.numDimensions = dimensionNames.length - 1;
        this.dimensionNames = dimensionNames;
        this.multidimCubeCellFactory = multidimCubeCellFactory;
        this.cells = multidimCubeCellFactory.newCells(0);
        for (int i = 0; i < this.numDimensions; ++i) {
            this.dimensionMembers.put(i, new LinkedList());
        }
    }

    @Override
    public String[] getDimensionNames() {
        return this.dimensionNames;
    }

    @Override
    public final int getNumDimensions() {
        return this.numDimensions;
    }

    @Override
    public final void setMembers(int dimension, Class enumType) {
        T[] enumConstants = enumType.getEnumConstants();
        if (enumConstants != null) {
            this.setMembers(dimension, Arrays.asList(enumConstants));
        }
    }

    @Override
    public final void setMembers(int dimension, List<Object> members) {
        List<Object> memberKeys = this.dimensionMembers.get(dimension);
        if (dimension < 0 || dimension > this.numDimensions - 1) {
            throw new IllegalArgumentException("Cannot add dimension members for given dimension - given dimension is out of range");
        }
        if (!memberKeys.isEmpty()) {
            throw new IllegalArgumentException("Cannot add dimension members - dimension members already existed, merge not supported");
        }
        if (!this.ordinals.isEmpty()) {
            throw new IllegalArgumentException("Cannot add dimension members - cells already existed, merge not supported");
        }
        for (Object member : members) {
            memberKeys.add(member);
        }
        int currentSize = this.cells.length;
        int newSize = currentSize * members.size();
        if (currentSize == 0) {
            newSize = members.size();
        }
        V[] newFacts = this.multidimCubeCellFactory.newCells(newSize);
        if (currentSize > 0) {
            System.arraycopy(this.cells, 0, newFacts, 0, currentSize);
        }
        for (int i = currentSize; i < newFacts.length; ++i) {
            newFacts[i] = this.multidimCubeCellFactory.newCell();
        }
        this.cells = newFacts;
    }

    @Override
    public final List<Object> getMembers(int dimension) {
        return this.dimensionMembers.get(dimension);
    }

    @Override
    public V getCell(MultiKeyUntyped coordinates) {
        if (coordinates.size() != this.numDimensions) {
            throw new IllegalArgumentException("Cannot return cell as number of dimension members does not match cube dimensions");
        }
        Integer ordinal = this.ordinals.get(coordinates);
        if (ordinal == null) {
            return null;
        }
        return this.cells[ordinal];
    }

    @Override
    public V getCellAddMembers(MultiKeyUntyped coordinates) {
        if (coordinates.size() != this.numDimensions) {
            throw new IllegalArgumentException("Cannot return cell as number of dimension members does not match cube dimensions");
        }
        Integer ordinal = this.ordinals.get(coordinates);
        if (ordinal != null) {
            return this.cells[ordinal];
        }
        int[] indizes = new int[this.numDimensions];
        boolean allMembersFound = this.calcIndizes(coordinates, indizes);
        if (allMembersFound) {
            int[] dimensionSizes = this.getDimensionSizes();
            ordinal = CubeDimensionHelper.getOrdinal(indizes, dimensionSizes);
            this.ordinals.put(coordinates, ordinal);
            return this.cells[ordinal];
        }
        if (this.cells.length == 0) {
            for (int i = 0; i < coordinates.size(); ++i) {
                Object member = coordinates.get(i);
                this.dimensionMembers.get(i).add(member);
            }
            this.cells = this.multidimCubeCellFactory.newCells(1);
            this.cells[0] = this.multidimCubeCellFactory.newCell();
            this.ordinals.put(coordinates, 0);
            return this.cells[0];
        }
        for (int i = 0; i < indizes.length; ++i) {
            if (indizes[i] != -1) continue;
            this.addMember(coordinates.get(i), i, this.multidimCubeCellFactory);
        }
        indizes = new int[this.numDimensions];
        allMembersFound = this.calcIndizes(coordinates, indizes);
        if (!allMembersFound) {
            throw new IllegalStateException("Internal error - member for dimension could not be added");
        }
        int[] dimensionSizes = this.getDimensionSizes();
        ordinal = CubeDimensionHelper.getOrdinal(indizes, dimensionSizes);
        this.ordinals.put(coordinates, ordinal);
        return this.cells[ordinal];
    }

    @Override
    public final V[] getCells() {
        return this.cells;
    }

    private void addMember(Object member, int dimension, MultidimCubeCellFactory<V> multidimCubeCellFactory) {
        int i;
        int[] oldDimensionSizes = this.getDimensionSizes();
        this.dimensionMembers.get(dimension).add(member);
        int[] newDimensionSizes = this.getDimensionSizes();
        int newSize = CubeDimensionHelper.getTotalCells(newDimensionSizes);
        V[] newFacts = multidimCubeCellFactory.newCells(newSize);
        if (dimension == this.numDimensions - 1) {
            System.arraycopy(this.cells, 0, newFacts, 0, this.cells.length);
            for (int i2 = this.cells.length; i2 < newFacts.length; ++i2) {
                newFacts[i2] = multidimCubeCellFactory.newCell();
            }
            this.cells = newFacts;
            return;
        }
        int[] indizes = new int[this.numDimensions];
        int[] newOrdinals = new int[this.cells.length];
        for (i = 0; i < this.cells.length; ++i) {
            int newOrdinal;
            newOrdinals[i] = newOrdinal = CubeDimensionHelper.getOrdinal(indizes, newDimensionSizes);
            newFacts[newOrdinal] = this.cells[i];
            if (i + 1 >= this.cells.length) continue;
            CubeDimensionHelper.nextIndize(oldDimensionSizes, indizes);
        }
        for (i = 0; i < newFacts.length; ++i) {
            if (newFacts[i] != null) continue;
            newFacts[i] = multidimCubeCellFactory.newCell();
        }
        for (Map.Entry<MultiKeyUntyped, Integer> entry : this.ordinals.entrySet()) {
            int oldOrdinal = entry.getValue();
            int newOrdinal = newOrdinals[oldOrdinal];
            this.ordinals.put(entry.getKey(), newOrdinal);
        }
        this.cells = newFacts;
    }

    private boolean calcIndizes(MultiKeyUntyped coordinates, int[] indizes) {
        boolean allFound = true;
        for (int i = 0; i < coordinates.size(); ++i) {
            Object memberKey = coordinates.get(i);
            List<Object> existingMembers = this.dimensionMembers.get(i);
            int index = existingMembers.indexOf(memberKey);
            if (index == -1) {
                allFound = false;
                indizes[i] = -1;
                continue;
            }
            indizes[i] = index;
        }
        return allFound;
    }

    private int[] getDimensionSizes() {
        int[] dimensionSizes = new int[this.numDimensions];
        for (int i = 0; i < this.numDimensions; ++i) {
            dimensionSizes[i] = this.dimensionMembers.get(i).size();
        }
        return dimensionSizes;
    }
}

