/*
 * Decompiled with CFR 0.152.
 */
package net.esper.view.std;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.esper.client.EPException;
import net.esper.collection.MultiKey;
import net.esper.collection.Pair;
import net.esper.core.StatementContext;
import net.esper.event.EventBean;
import net.esper.event.EventBeanUtility;
import net.esper.event.EventPropertyGetter;
import net.esper.event.EventType;
import net.esper.util.ExecutionPathDebugLog;
import net.esper.view.CloneableView;
import net.esper.view.View;
import net.esper.view.ViewSupport;
import net.esper.view.Viewable;
import net.esper.view.std.AddPropertyValueView;
import net.esper.view.std.MergeView;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GroupByView
extends ViewSupport
implements CloneableView {
    private final String[] groupFieldNames;
    private final StatementContext statementContext;
    private EventPropertyGetter[] groupFieldGetters;
    private final Map<MultiKey<Object>, List<View>> subViewsPerKey = new HashMap<MultiKey<Object>, List<View>>();
    private HashMap<List<View>, Pair<List<EventBean>, List<EventBean>>> groupedEvents = new HashMap();
    private static final Log log = LogFactory.getLog(GroupByView.class);

    public GroupByView(StatementContext statementContext, String[] groupFieldNames) {
        this.statementContext = statementContext;
        this.groupFieldNames = groupFieldNames;
    }

    @Override
    public View cloneView(StatementContext statementContext) {
        return new GroupByView(statementContext, this.groupFieldNames);
    }

    @Override
    public void setParent(Viewable parent) {
        super.setParent(parent);
        if (parent == null) {
            return;
        }
        this.groupFieldGetters = new EventPropertyGetter[this.groupFieldNames.length];
        for (int i = 0; i < this.groupFieldNames.length; ++i) {
            this.groupFieldGetters[i] = parent.getEventType().getGetter(this.groupFieldNames[i]);
        }
    }

    public String[] getGroupFieldNames() {
        return this.groupFieldNames;
    }

    @Override
    public final EventType getEventType() {
        return this.parent.getEventType();
    }

    @Override
    public final void update(EventBean[] newData, EventBean[] oldData) {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".update Updating view");
            GroupByView.dumpUpdateParams("GroupByView", newData, oldData);
        }
        if (newData != null) {
            for (EventBean newValue : newData) {
                this.handleEvent(newValue, true);
            }
        }
        if (oldData != null) {
            for (EventBean oldValue : oldData) {
                this.handleEvent(oldValue, false);
            }
        }
        for (Map.Entry<List<View>, Pair<List<EventBean>, List<EventBean>>> entry : this.groupedEvents.entrySet()) {
            EventBean[] newEvents = EventBeanUtility.toArray(entry.getValue().getFirst());
            EventBean[] oldEvents = EventBeanUtility.toArray(entry.getValue().getSecond());
            ViewSupport.updateChildren(entry.getKey(), newEvents, oldEvents);
        }
        this.groupedEvents.clear();
    }

    private void handleEvent(EventBean event, boolean isNew) {
        Pair<List<EventBean>, List<EventBean>> pair;
        Object[] groupByValues = new Object[this.groupFieldGetters.length];
        for (int i = 0; i < this.groupFieldGetters.length; ++i) {
            groupByValues[i] = this.groupFieldGetters[i].get(event);
        }
        MultiKey<Object> groupByValuesKey = new MultiKey<Object>(groupByValues);
        List<View> subViews = this.subViewsPerKey.get(groupByValuesKey);
        if (subViews == null) {
            subViews = GroupByView.makeSubViews(this, groupByValuesKey.getArray(), this.statementContext);
            this.subViewsPerKey.put(groupByValuesKey, subViews);
        }
        if ((pair = this.groupedEvents.get(subViews)) == null) {
            LinkedList listNew = new LinkedList();
            LinkedList listOld = new LinkedList();
            pair = new Pair(listNew, listOld);
            this.groupedEvents.put(subViews, pair);
        }
        if (isNew) {
            pair.getFirst().add(event);
        } else {
            pair.getSecond().add(event);
        }
    }

    @Override
    public final Iterator<EventBean> iterator() {
        throw new UnsupportedOperationException("Cannot iterate over group view, this operation is not supported");
    }

    public final String toString() {
        return this.getClass().getName() + " groupFieldNames=" + Arrays.toString(this.groupFieldNames);
    }

    protected static List<View> makeSubViews(GroupByView groupView, Object[] groupByValues, StatementContext statementContext) {
        if (!groupView.hasViews()) {
            String message = "Unexpected empty list of child nodes for group view";
            log.fatal(".copySubViews " + message);
            throw new EPException(message);
        }
        LinkedList<View> subViewList = new LinkedList<View>();
        for (View originalChildView : groupView.getViews()) {
            if (originalChildView instanceof MergeView) {
                String message = "Unexpected merge view as child of group-by view";
                log.fatal(".copySubViews " + message);
                throw new EPException(message);
            }
            if (!(originalChildView instanceof CloneableView)) {
                throw new EPException("Unexpected error copying subview " + originalChildView.getClass().getName());
            }
            CloneableView cloneableView = (CloneableView)((Object)originalChildView);
            View copyChildView = cloneableView.cloneView(statementContext);
            copyChildView.setParent(groupView);
            subViewList.add(copyChildView);
            GroupByView.copySubViews(groupView.groupFieldNames, groupByValues, originalChildView, copyChildView, statementContext);
        }
        return subViewList;
    }

    private static void copySubViews(String[] groupFieldNames, Object[] groupByValues, View originalView, View copyView, StatementContext statementContext) {
        for (View subView : originalView.getViews()) {
            MergeView mergeView;
            if (subView instanceof MergeView && Arrays.equals((mergeView = (MergeView)subView).getGroupFieldNames(), groupFieldNames)) {
                AddPropertyValueView mergeDataView = new AddPropertyValueView(statementContext, groupFieldNames, groupByValues, mergeView.getEventType());
                copyView.addView(mergeDataView);
                mergeDataView.addView(mergeView);
                mergeView.addParentView(mergeDataView);
                continue;
            }
            if (!(subView instanceof CloneableView)) {
                throw new EPException("Unexpected error copying subview");
            }
            CloneableView cloneableView = (CloneableView)((Object)subView);
            View copiedChild = cloneableView.cloneView(statementContext);
            copyView.addView(copiedChild);
            GroupByView.copySubViews(groupFieldNames, groupByValues, subView, copiedChild, statementContext);
        }
    }
}

