/*
 * Decompiled with CFR 0.152.
 */
package net.esper.view.std;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.esper.core.StatementContext;
import net.esper.eql.core.ViewResourceCallback;
import net.esper.event.EventType;
import net.esper.view.PropertyCheckHelper;
import net.esper.view.View;
import net.esper.view.ViewAttachException;
import net.esper.view.ViewCapability;
import net.esper.view.ViewFactory;
import net.esper.view.ViewFactoryContext;
import net.esper.view.ViewParameterException;
import net.esper.view.std.GroupByView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupByViewFactory
implements ViewFactory {
    protected String[] groupFieldNames;
    private EventType eventType;

    @Override
    public void setViewParameters(ViewFactoryContext viewFactoryContext, List<Object> viewParameters) throws ViewParameterException {
        this.groupFieldNames = GroupByViewFactory.getFieldNameParams(viewParameters, "Group-by");
    }

    @Override
    public void attach(EventType parentEventType, StatementContext statementContext, ViewFactory optionalParentFactory, List<ViewFactory> parentViewFactories) throws ViewAttachException {
        for (int i = 0; i < this.groupFieldNames.length; ++i) {
            String message = PropertyCheckHelper.exists(parentEventType, this.groupFieldNames[i]);
            if (message == null) continue;
            throw new ViewAttachException(message);
        }
        this.eventType = parentEventType;
    }

    public String[] getGroupFieldNames() {
        return this.groupFieldNames;
    }

    @Override
    public boolean canProvideCapability(ViewCapability viewCapability) {
        return false;
    }

    @Override
    public void setProvideCapability(ViewCapability viewCapability, ViewResourceCallback resourceCallback) {
        throw new UnsupportedOperationException("View capability " + viewCapability.getClass().getSimpleName() + " not supported");
    }

    @Override
    public View makeView(StatementContext statementContext) {
        return new GroupByView(statementContext, this.groupFieldNames);
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    protected static String[] getFieldNameParams(List<Object> viewParameters, String viewName) throws ViewParameterException {
        String[] fieldNames;
        String errorMessage = '\'' + viewName + "' view requires a list of String values or a String-array as parameter";
        if (viewParameters.isEmpty()) {
            throw new ViewParameterException(errorMessage);
        }
        if (viewParameters.size() > 1) {
            ArrayList<String> fields = new ArrayList<String>();
            for (Object param : viewParameters) {
                if (!(param instanceof String)) {
                    throw new ViewParameterException(errorMessage);
                }
                fields.add((String)param);
            }
            fieldNames = fields.toArray(new String[0]);
        } else {
            Object param = viewParameters.get(0);
            if (param instanceof String[]) {
                String[] arr = (String[])param;
                if (arr.length == 0) {
                    throw new ViewParameterException(errorMessage);
                }
                fieldNames = arr;
            } else if (param instanceof String) {
                fieldNames = new String[]{(String)param};
            } else {
                throw new ViewParameterException(errorMessage);
            }
        }
        return fieldNames;
    }

    @Override
    public boolean canReuse(View view) {
        if (!(view instanceof GroupByView)) {
            return false;
        }
        GroupByView myView = (GroupByView)view;
        return Arrays.deepEquals(myView.getGroupFieldNames(), this.groupFieldNames);
    }
}

