/*
 * Decompiled with CFR 0.152.
 */
package net.esper.view.std;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import net.esper.collection.IterablesListIterator;
import net.esper.core.StatementContext;
import net.esper.event.EventBean;
import net.esper.event.EventType;
import net.esper.util.ExecutionPathDebugLog;
import net.esper.view.CloneableView;
import net.esper.view.View;
import net.esper.view.ViewSupport;
import net.esper.view.std.AddPropertyValueView;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MergeView
extends ViewSupport
implements CloneableView {
    private final LinkedList<View> parentViews = new LinkedList();
    private final String[] groupFieldNames;
    private final EventType eventType;
    private static final Log log = LogFactory.getLog(MergeView.class);

    public MergeView(StatementContext statementContext, String[] groupFieldNames, EventType resultEventType) {
        this.groupFieldNames = groupFieldNames;
        this.eventType = resultEventType;
    }

    @Override
    public View cloneView(StatementContext statementContext) {
        return new MergeView(statementContext, this.groupFieldNames, this.eventType);
    }

    public final String[] getGroupFieldNames() {
        return this.groupFieldNames;
    }

    public final void addParentView(AddPropertyValueView parentView) {
        this.parentViews.add(parentView);
    }

    @Override
    public final EventType getEventType() {
        return this.eventType;
    }

    @Override
    public final void update(EventBean[] newData, EventBean[] oldData) {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".update Updating view");
            MergeView.dumpUpdateParams("MergeView", newData, oldData);
        }
        this.updateChildren(newData, oldData);
    }

    @Override
    public final Iterator<EventBean> iterator() {
        LinkedList<Iterable<EventBean>> iterables = new LinkedList<Iterable<EventBean>>();
        for (View dataView : this.parentViews) {
            iterables.add(dataView);
        }
        return new IterablesListIterator(iterables);
    }

    public final String toString() {
        return this.getClass().getName() + " groupFieldName=" + Arrays.toString(this.groupFieldNames);
    }
}

