/*
 * Decompiled with CFR 0.152.
 */
package net.esper.view.std;

import java.util.Arrays;
import java.util.List;
import net.esper.core.StatementContext;
import net.esper.eql.core.ViewResourceCallback;
import net.esper.event.EventType;
import net.esper.view.View;
import net.esper.view.ViewAttachException;
import net.esper.view.ViewCapability;
import net.esper.view.ViewFactory;
import net.esper.view.ViewFactoryContext;
import net.esper.view.ViewParameterException;
import net.esper.view.std.GroupByViewFactory;
import net.esper.view.std.MergeView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeViewFactory
implements ViewFactory {
    private String[] fieldNames;
    private EventType eventType;

    @Override
    public void setViewParameters(ViewFactoryContext viewFactoryContext, List<Object> viewParameters) throws ViewParameterException {
        this.fieldNames = GroupByViewFactory.getFieldNameParams(viewParameters, "Group-by-merge");
    }

    @Override
    public void attach(EventType parentEventType, StatementContext statementContext, ViewFactory optionalParentFactory, List<ViewFactory> parentViewFactories) throws ViewAttachException {
        ViewFactory groupByViewFactory = null;
        for (ViewFactory parentView : parentViewFactories) {
            GroupByViewFactory candidateGroupByView;
            if (!(parentView instanceof GroupByViewFactory) || !Arrays.equals((candidateGroupByView = (GroupByViewFactory)parentView).getGroupFieldNames(), this.fieldNames)) continue;
            groupByViewFactory = candidateGroupByView;
        }
        if (groupByViewFactory == null) {
            throw new ViewAttachException("Group by view for this merge view could not be found among parent views");
        }
        Class[] fieldTypes = new Class[this.fieldNames.length];
        for (int i = 0; i < fieldTypes.length; ++i) {
            fieldTypes[i] = groupByViewFactory.getEventType().getPropertyType(this.fieldNames[i]);
        }
        boolean parentContainsMergeKeys = true;
        for (int i = 0; i < this.fieldNames.length; ++i) {
            if (parentEventType.isProperty(this.fieldNames[i])) continue;
            parentContainsMergeKeys = false;
        }
        this.eventType = parentContainsMergeKeys ? parentEventType : statementContext.getEventAdapterService().createAddToEventType(parentEventType, this.fieldNames, fieldTypes);
    }

    @Override
    public boolean canProvideCapability(ViewCapability viewCapability) {
        return false;
    }

    @Override
    public void setProvideCapability(ViewCapability viewCapability, ViewResourceCallback resourceCallback) {
        throw new UnsupportedOperationException("View capability " + viewCapability.getClass().getSimpleName() + " not supported");
    }

    @Override
    public View makeView(StatementContext statementContext) {
        return new MergeView(statementContext, this.fieldNames, this.eventType);
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public boolean canReuse(View view) {
        if (!(view instanceof MergeView)) {
            return false;
        }
        MergeView myView = (MergeView)view;
        return Arrays.deepEquals(myView.getGroupFieldNames(), this.fieldNames);
    }
}

