/*
 * Decompiled with CFR 0.152.
 */
package net.esper.view.std;

import java.util.HashMap;
import java.util.Iterator;
import net.esper.collection.SingleEventIterator;
import net.esper.core.StatementContext;
import net.esper.event.EventBean;
import net.esper.event.EventType;
import net.esper.view.CloneableView;
import net.esper.view.View;
import net.esper.view.ViewFieldEnum;
import net.esper.view.ViewSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SizeView
extends ViewSupport
implements CloneableView {
    private final StatementContext statementContext;
    private EventType eventType;
    private long size = 0L;
    private EventBean lastSizeEvent;

    public SizeView(StatementContext statementContext) {
        this.statementContext = statementContext;
        this.eventType = SizeView.createEventType(statementContext);
    }

    @Override
    public View cloneView(StatementContext statementContext) {
        return new SizeView(statementContext);
    }

    @Override
    public final EventType getEventType() {
        return this.eventType;
    }

    @Override
    public final void update(EventBean[] newData, EventBean[] oldData) {
        long priorSize = this.size;
        if (newData != null) {
            this.size += (long)newData.length;
        }
        if (oldData != null) {
            this.size -= (long)oldData.length;
        }
        if (this.hasViews() && priorSize != this.size) {
            HashMap<String, Object> postNewData = new HashMap<String, Object>();
            postNewData.put(ViewFieldEnum.SIZE_VIEW__SIZE.getName(), this.size);
            EventBean newEvent = this.statementContext.getEventAdapterService().createMapFromValues(postNewData, this.eventType);
            if (this.lastSizeEvent != null) {
                this.updateChildren(new EventBean[]{newEvent}, new EventBean[]{this.lastSizeEvent});
            } else {
                HashMap<String, Object> postOldData = new HashMap<String, Object>();
                postOldData.put(ViewFieldEnum.SIZE_VIEW__SIZE.getName(), priorSize);
                EventBean oldEvent = this.statementContext.getEventAdapterService().createMapFromValues(postOldData, this.eventType);
                this.updateChildren(new EventBean[]{newEvent}, new EventBean[]{oldEvent});
            }
            this.lastSizeEvent = newEvent;
        }
    }

    @Override
    public final Iterator<EventBean> iterator() {
        HashMap<String, Object> current = new HashMap<String, Object>();
        current.put(ViewFieldEnum.SIZE_VIEW__SIZE.getName(), this.size);
        return new SingleEventIterator(this.statementContext.getEventAdapterService().createMapFromValues(current, this.eventType));
    }

    public final String toString() {
        return this.getClass().getName();
    }

    protected static EventType createEventType(StatementContext statementContext) {
        HashMap<String, Class> schemaMap = new HashMap<String, Class>();
        schemaMap.put(ViewFieldEnum.SIZE_VIEW__SIZE.getName(), Long.TYPE);
        return statementContext.getEventAdapterService().createAnonymousMapType(schemaMap);
    }
}

