/*
 * Decompiled with CFR 0.152.
 */
package net.esper.view.std;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.esper.collection.OneEventLinkedList;
import net.esper.core.StatementContext;
import net.esper.event.EventBean;
import net.esper.event.EventPropertyGetter;
import net.esper.event.EventType;
import net.esper.util.ExecutionPathDebugLog;
import net.esper.view.CloneableView;
import net.esper.view.View;
import net.esper.view.ViewSupport;
import net.esper.view.Viewable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UniqueByPropertyView
extends ViewSupport
implements CloneableView {
    private final String uniqueFieldName;
    private EventPropertyGetter uniqueFieldGetter;
    private final Map<Object, EventBean> mostRecentEvents = new LinkedHashMap<Object, EventBean>();
    private static final Log log = LogFactory.getLog(UniqueByPropertyView.class);

    public UniqueByPropertyView(String uniqueFieldName) {
        this.uniqueFieldName = uniqueFieldName;
    }

    @Override
    public View cloneView(StatementContext statementContext) {
        return new UniqueByPropertyView(this.uniqueFieldName);
    }

    @Override
    public void setParent(Viewable parent) {
        super.setParent(parent);
        if (parent != null) {
            this.uniqueFieldGetter = parent.getEventType().getGetter(this.uniqueFieldName);
        }
    }

    public final String getUniqueFieldName() {
        return this.uniqueFieldName;
    }

    @Override
    public final EventType getEventType() {
        return this.parent.getEventType();
    }

    @Override
    public final void update(EventBean[] newData, EventBean[] oldData) {
        EventBean lastValue;
        Object uniqueValue;
        int i;
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".update Updating view");
            UniqueByPropertyView.dumpUpdateParams("UniqueByPropertyView", newData, oldData);
        }
        OneEventLinkedList postOldData = null;
        if (this.hasViews()) {
            postOldData = new OneEventLinkedList();
        }
        if (newData != null) {
            for (i = 0; i < newData.length; ++i) {
                uniqueValue = this.uniqueFieldGetter.get(newData[i]);
                if (!this.hasViews()) {
                    this.mostRecentEvents.put(uniqueValue, newData[i]);
                    continue;
                }
                lastValue = this.mostRecentEvents.get(uniqueValue);
                if (lastValue != null) {
                    postOldData.add(lastValue);
                }
                this.mostRecentEvents.put(uniqueValue, newData[i]);
            }
        }
        if (oldData != null) {
            for (i = 0; i < oldData.length; ++i) {
                uniqueValue = this.uniqueFieldGetter.get(oldData[i]);
                lastValue = this.mostRecentEvents.get(uniqueValue);
                if (lastValue != oldData[i]) continue;
                postOldData.add(lastValue);
                this.mostRecentEvents.remove(uniqueValue);
            }
        }
        if (this.hasViews()) {
            if (postOldData.isEmpty()) {
                this.updateChildren(newData, null);
            } else {
                this.updateChildren(newData, postOldData.toArray());
            }
        }
    }

    @Override
    public final Iterator<EventBean> iterator() {
        return this.mostRecentEvents.values().iterator();
    }

    public final String toString() {
        return this.getClass().getName() + " uniqueFieldName=" + this.uniqueFieldName;
    }
}

