/*
 * Decompiled with CFR 0.152.
 */
package net.esper.view.stream;

import java.util.IdentityHashMap;
import net.esper.collection.Pair;
import net.esper.collection.RefCountedMap;
import net.esper.core.EPStatementHandle;
import net.esper.core.EPStatementHandleCallback;
import net.esper.event.EventBean;
import net.esper.event.EventType;
import net.esper.filter.FilterHandleCallback;
import net.esper.filter.FilterService;
import net.esper.filter.FilterSpecCompiled;
import net.esper.filter.FilterValueSet;
import net.esper.util.ManagedLock;
import net.esper.view.EventStream;
import net.esper.view.ZeroDepthStream;
import net.esper.view.stream.StreamFactoryService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StreamFactorySvcImpl
implements StreamFactoryService {
    private static Log log = LogFactory.getLog(StreamFactorySvcImpl.class);
    private final IdentityHashMap<FilterSpecCompiled, Pair<EventStream, EPStatementHandleCallback>> eventStreamsIdentity;
    private final RefCountedMap<FilterSpecCompiled, Pair<EventStream, EPStatementHandleCallback>> eventStreamsRefCounted = new RefCountedMap();
    private boolean isReuseViews;

    public StreamFactorySvcImpl(boolean isReuseViews) {
        this.eventStreamsIdentity = new IdentityHashMap();
        this.isReuseViews = isReuseViews;
    }

    @Override
    public void destroy() {
        this.eventStreamsRefCounted.clear();
        this.eventStreamsIdentity.clear();
    }

    @Override
    public Pair<EventStream, ManagedLock> createStream(FilterSpecCompiled filterSpec, FilterService filterService, EPStatementHandle epStatementHandle, boolean isJoin) {
        if (log.isDebugEnabled()) {
            log.debug(".createStream hashCode=" + filterSpec.hashCode() + " filter=" + filterSpec);
        }
        Pair<EventStream, EPStatementHandleCallback> pair = null;
        boolean forceNewStream = isJoin || !this.isReuseViews;
        pair = forceNewStream ? this.eventStreamsIdentity.get(filterSpec) : this.eventStreamsRefCounted.get(filterSpec);
        if (pair != null) {
            if (forceNewStream) {
                throw new IllegalStateException("Filter spec object already found in collection");
            }
            log.debug(".createStream filter already found");
            this.eventStreamsRefCounted.reference(filterSpec);
            return new Pair<EventStream, ManagedLock>(pair.getFirst(), pair.getSecond().getEpStatementHandle().getStatementLock());
        }
        EventType eventType = filterSpec.getEventType();
        final ZeroDepthStream eventStream = new ZeroDepthStream(eventType);
        FilterHandleCallback filterCallback = new FilterHandleCallback(){

            public void matchFound(EventBean event) {
                eventStream.insert(event);
            }
        };
        EPStatementHandleCallback handle = new EPStatementHandleCallback(epStatementHandle, filterCallback);
        pair = new Pair<ZeroDepthStream, EPStatementHandleCallback>(eventStream, handle);
        if (forceNewStream) {
            this.eventStreamsIdentity.put(filterSpec, pair);
        } else {
            this.eventStreamsRefCounted.put(filterSpec, pair);
        }
        FilterValueSet filterValues = filterSpec.getValueSet(null);
        filterService.add(filterValues, handle);
        return new Pair<ZeroDepthStream, Object>(eventStream, null);
    }

    @Override
    public void dropStream(FilterSpecCompiled filterSpec, FilterService filterService, boolean isJoin) {
        boolean forceNewStream;
        Pair<EventStream, EPStatementHandleCallback> pair = null;
        boolean bl = forceNewStream = isJoin || !this.isReuseViews;
        if (forceNewStream) {
            pair = this.eventStreamsIdentity.get(filterSpec);
            if (pair == null) {
                throw new IllegalStateException("Filter spec object not in collection");
            }
            this.eventStreamsIdentity.remove(filterSpec);
            filterService.remove(pair.getSecond());
        } else {
            pair = this.eventStreamsRefCounted.get(filterSpec);
            boolean isLast = this.eventStreamsRefCounted.dereference(filterSpec);
            if (isLast) {
                filterService.remove(pair.getSecond());
            }
        }
    }
}

