/*
 * Decompiled with CFR 0.152.
 */
package net.esper.view.window;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.esper.collection.TimeWindow;
import net.esper.collection.ViewUpdatedCollection;
import net.esper.core.StatementContext;
import net.esper.event.EventBean;
import net.esper.event.EventPropertyGetter;
import net.esper.event.EventType;
import net.esper.view.CloneableView;
import net.esper.view.DataWindowView;
import net.esper.view.View;
import net.esper.view.ViewSupport;
import net.esper.view.Viewable;
import net.esper.view.window.ExternallyTimedWindowViewFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExternallyTimedWindowView
extends ViewSupport
implements DataWindowView,
CloneableView {
    private final ExternallyTimedWindowViewFactory externallyTimedWindowViewFactory;
    private final String timestampFieldName;
    private final long millisecondsBeforeExpiry;
    private EventPropertyGetter timestampFieldGetter;
    private final TimeWindow timeWindow;
    private ViewUpdatedCollection viewUpdatedCollection;
    private boolean isRemoveStreamHandling;

    public ExternallyTimedWindowView(ExternallyTimedWindowViewFactory externallyTimedWindowViewFactory, String timestampFieldName, long msecBeforeExpiry, ViewUpdatedCollection viewUpdatedCollection, boolean isRemoveStreamHandling) {
        this.externallyTimedWindowViewFactory = externallyTimedWindowViewFactory;
        this.timestampFieldName = timestampFieldName;
        this.millisecondsBeforeExpiry = msecBeforeExpiry;
        this.viewUpdatedCollection = viewUpdatedCollection;
        this.isRemoveStreamHandling = isRemoveStreamHandling;
        this.timeWindow = new TimeWindow(isRemoveStreamHandling);
    }

    @Override
    public View cloneView(StatementContext statementContext) {
        return this.externallyTimedWindowViewFactory.makeView(statementContext);
    }

    public final String getTimestampFieldName() {
        return this.timestampFieldName;
    }

    @Override
    public void setParent(Viewable parent) {
        super.setParent(parent);
        if (parent != null) {
            this.timestampFieldGetter = parent.getEventType().getGetter(this.timestampFieldName);
        }
    }

    public final long getMillisecondsBeforeExpiry() {
        return this.millisecondsBeforeExpiry;
    }

    @Override
    public final EventType getEventType() {
        return this.parent.getEventType();
    }

    @Override
    public final void update(EventBean[] newData, EventBean[] oldData) {
        long timestamp = -1L;
        if (newData != null) {
            for (int i = 0; i < newData.length; ++i) {
                timestamp = this.getLongValue(newData[i]);
                this.timeWindow.add(timestamp, newData[i]);
            }
        }
        List<EventBean> expired = null;
        if (timestamp != -1L) {
            expired = this.timeWindow.expireEvents(timestamp - this.millisecondsBeforeExpiry + 1L);
        }
        EventBean[] oldDataUpdate = null;
        if (expired != null && !expired.isEmpty()) {
            oldDataUpdate = expired.toArray(new EventBean[0]);
        }
        if (oldData != null && this.isRemoveStreamHandling) {
            for (EventBean anOldData : oldData) {
                this.timeWindow.remove(anOldData);
            }
            if (oldDataUpdate == null) {
                oldDataUpdate = oldData;
            } else {
                HashSet<EventBean> oldDataPost = new HashSet<EventBean>();
                for (EventBean old : oldData) {
                    oldDataPost.add(old);
                }
                for (EventBean old : oldDataUpdate) {
                    oldDataPost.add(old);
                }
                oldDataUpdate = oldDataPost.toArray(new EventBean[0]);
            }
        }
        if (this.viewUpdatedCollection != null) {
            this.viewUpdatedCollection.update(newData, oldDataUpdate);
        }
        if (this.hasViews()) {
            this.updateChildren(newData, oldDataUpdate);
        }
    }

    @Override
    public final Iterator<EventBean> iterator() {
        return this.timeWindow.iterator();
    }

    public final String toString() {
        return this.getClass().getName() + " timestampFieldName=" + this.timestampFieldName + " millisecondsBeforeExpiry=" + this.millisecondsBeforeExpiry;
    }

    private long getLongValue(EventBean obj) {
        Number num = (Number)this.timestampFieldGetter.get(obj);
        return num.longValue();
    }

    public boolean isEmpty() {
        return this.timeWindow.isEmpty();
    }
}

