/*
 * Decompiled with CFR 0.152.
 */
package net.esper.view.window;

import java.util.List;
import net.esper.core.StatementContext;
import net.esper.eql.core.ViewResourceCallback;
import net.esper.eql.named.RemoveStreamViewCapability;
import net.esper.event.EventType;
import net.esper.type.TimePeriodParameter;
import net.esper.util.JavaClassHelper;
import net.esper.view.DataWindowViewFactory;
import net.esper.view.PropertyCheckHelper;
import net.esper.view.View;
import net.esper.view.ViewAttachException;
import net.esper.view.ViewCapDataWindowAccess;
import net.esper.view.ViewCapability;
import net.esper.view.ViewFactory;
import net.esper.view.ViewFactoryContext;
import net.esper.view.ViewParameterException;
import net.esper.view.window.ExternallyTimedWindowView;
import net.esper.view.window.IStreamRandomAccess;
import net.esper.view.window.RandomAccessByIndexGetter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternallyTimedWindowViewFactory
implements DataWindowViewFactory {
    private EventType eventType;
    protected String timestampFieldName;
    protected long millisecondsBeforeExpiry;
    protected boolean isRemoveStreamHandling;
    protected RandomAccessByIndexGetter randomAccessGetterImpl;

    @Override
    public void setViewParameters(ViewFactoryContext viewFactoryContext, List<Object> viewParameters) throws ViewParameterException {
        String errorMessage = "Externally-timed window view requires a timestamp field name and a numeric or time period parameter";
        if (viewParameters.size() != 2) {
            throw new ViewParameterException(errorMessage);
        }
        if (!(viewParameters.get(0) instanceof String)) {
            throw new ViewParameterException(errorMessage);
        }
        this.timestampFieldName = (String)viewParameters.get(0);
        Object parameter = viewParameters.get(1);
        if (parameter instanceof TimePeriodParameter) {
            TimePeriodParameter param = (TimePeriodParameter)parameter;
            this.millisecondsBeforeExpiry = Math.round(1000.0 * param.getNumSeconds());
        } else {
            if (!(parameter instanceof Number)) {
                throw new ViewParameterException(errorMessage);
            }
            Number param = (Number)parameter;
            this.millisecondsBeforeExpiry = JavaClassHelper.isFloatingPointNumber(param) ? Math.round(1000.0 * param.doubleValue()) : 1000L * param.longValue();
        }
    }

    @Override
    public void attach(EventType parentEventType, StatementContext statementContext, ViewFactory optionalParentFactory, List<ViewFactory> parentViewFactories) throws ViewAttachException {
        String message = PropertyCheckHelper.checkLong(parentEventType, this.timestampFieldName);
        if (message != null) {
            throw new ViewAttachException(message);
        }
        this.eventType = parentEventType;
    }

    @Override
    public boolean canProvideCapability(ViewCapability viewCapability) {
        if (viewCapability instanceof ViewCapDataWindowAccess) {
            return true;
        }
        return viewCapability instanceof RemoveStreamViewCapability;
    }

    @Override
    public void setProvideCapability(ViewCapability viewCapability, ViewResourceCallback resourceCallback) {
        if (!this.canProvideCapability(viewCapability)) {
            throw new UnsupportedOperationException("View capability " + viewCapability.getClass().getSimpleName() + " not supported");
        }
        if (viewCapability instanceof RemoveStreamViewCapability) {
            this.isRemoveStreamHandling = true;
            return;
        }
        if (this.randomAccessGetterImpl == null) {
            this.randomAccessGetterImpl = new RandomAccessByIndexGetter();
        }
        resourceCallback.setViewResource(this.randomAccessGetterImpl);
    }

    @Override
    public View makeView(StatementContext statementContext) {
        IStreamRandomAccess randomAccess = null;
        if (this.randomAccessGetterImpl != null) {
            randomAccess = new IStreamRandomAccess(this.randomAccessGetterImpl);
            this.randomAccessGetterImpl.updated(randomAccess);
        }
        return new ExternallyTimedWindowView(this, this.timestampFieldName, this.millisecondsBeforeExpiry, randomAccess, this.isRemoveStreamHandling);
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public boolean canReuse(View view) {
        if (this.randomAccessGetterImpl != null) {
            return false;
        }
        if (!(view instanceof ExternallyTimedWindowView)) {
            return false;
        }
        ExternallyTimedWindowView myView = (ExternallyTimedWindowView)view;
        if (myView.getMillisecondsBeforeExpiry() != this.millisecondsBeforeExpiry || !myView.getTimestampFieldName().equals(this.timestampFieldName)) {
            return false;
        }
        return myView.isEmpty();
    }
}

